% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{alasso}
\alias{alasso}
\title{Adaptive Lasso}
\usage{
alasso(data, index, weights_method = c("ols", "ridge"), ols_ps = TRUE)
}
\arguments{
\item{data}{A data frame or matrix containing the predictors and response.
The response must be in the first column.}

\item{index}{A numeric vector of indices indicating the rows of 'data' to use
for the adaptive lasso regression.}

\item{weights_method}{A character string specifying the method to calculate
the weights. Can be either "ols" or "ridge". Default
is "ols".}

\item{ols_ps}{A logical scalar. If TRUE (default), the function returns the
coefficients from the OLS fit. If FALSE, it returns the
coefficients from the lasso fit.}
}
\value{
A numeric vector of coefficients. If 'ols_ps' is TRUE, these are the
        coefficients from the OLS fit. If 'ols_ps' is FALSE, these are the
        coefficients from the lasso fit. If an error occurs during the lasso
        or OLS fit, the function returns a vector of NAs.
}
\description{
This function performs adaptive lasso regression using the cv.glmnet function,
then refits the model using ordinary least squares.
}
