% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{figure_comparison.as_data}
\alias{figure_comparison.as_data}
\title{Figure Comparison}
\usage{
\method{figure_comparison}{as_data}(
  data_object,
  ties = "different_data_points",
  main = "Option Comparison",
  labels = NULL,
  mllabel = NULL,
  test = TRUE,
  predictions,
  by_families = FALSE,
  stacked = TRUE,
  color_list = NULL,
  legend = TRUE,
  ordered_option_names = NULL,
  xlab = "Criteria",
  ylab = "Instances (\%)",
  ...
)
}
\arguments{
\item{data_object}{object of class \code{as_data}.}

\item{ties}{How to deal with ties. Must be one of:
\itemize{
\item "different_data_points": Tied algorithms in the optimal selection are all counted as different data points (increasing the total number of x values and therefore giving all of the tied algorithms the same weight).
\item "ml_if_optimal": For tied algorithms, the one selected by ML is chosen if it corresponds to the optimal one. Otherwise, the same as in option \code{different_data_points} is done.
\item "ml_selection": For tied algorithms, the one preferred by the ML is chosen.
}}

\item{main}{an overall title for the plot.}

\item{labels}{character vector with the labels for each of the algorithms. If NULL, the y names of the \code{data_object} names will be used.}

\item{mllabel}{character vector with the labels for the Optimal and ML bars. If NULL, default names will be used.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows).}

\item{by_families}{boolean indicating whether the function should represent data by families or not. The family information must be included in the \code{data_object} parameter.}

\item{stacked}{boolean to choose between bar plot and stacked bar plot.}

\item{color_list}{list with the colors for the plots. If NULL, or insufficient number of colors, the colors will be generated automatically.}

\item{legend}{boolean to activate or deactivate the legend in the plot.}

\item{ordered_option_names}{vector with the name of the columns of data_object y variable in the correct order.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{...}{other parameters.}
}
\value{
A \code{ggplot} object representing the bar plot with the percentage of times each algorithm is selected by ML compared with the optimal selection (according to the response variable or KPI).
}
\description{
Represents a bar plot with the percentage of times each algorithm is selected by ML compared with the optimal selection (according to the response variable or KPI).
}
\examples{
data(branchingsmall)
data <- partition_and_normalize(branchingsmall$x, branchingsmall$y)
training <- AStrain(data, method = "glm")
predict_test <- ASpredict(training, newdata = data$x.test)
figure_comparison(data, predictions = predict_test)
}
