% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat123}
\alias{simDat123}
\title{Simulate data for Chapter 12.3: Zero-inflated counts}
\usage{
simDat123(nSites = 50, alpha = log(2), beta = log(5) - log(2), psi = 0.2)
}
\arguments{
\item{nSites}{Number of sites}

\item{alpha}{Intercept}

\item{beta}{Slope for land use}

\item{psi}{Zero inflation parameter (probability of structural 0)}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Number of sites}
  \item{alpha}{Intercept}
  \item{beta}{Slope for land use}
  \item{psi}{Zero inflation parameter}
  \item{w}{Indicator that count is not a structural 0}
  \item{C}{Simulated hare counts with zero inflation}
}
\description{
Generate counts of hares in two landuse types when there may be 
zero-inflation (this is a simple general hierarchical model, see Chapters 19 and 19B in the book)
}
\examples{
str(dat <- simDat123())      # Implicit default arguments

# Drop zero inflation (and make sample sizes bigger)
str(dat <- simDat123(nSites = 1000, psi = 0))     # Note 0 \% of the sites have structural zeroes now

# Half of all sites have structural zeroes
str(dat <- simDat123(nSites = 1000, psi = 0.5))

# Revert to "model-of-the-mean" without zero inflation
# 0 \% of the sites have structural zeroes
str(dat <- simDat123(nSites = 1000, beta = 0, psi = 0))

# Revert to "model-of-the-mean" with zero inflation
# 50 \% of the sites have structural zeroes
str(dat <- simDat123(nSites = 1000, beta = 0, psi = 0.5))

}
\author{
Marc Kéry
}
