% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat17}
\alias{simDat17}
\title{Simulate data for Chapter 17: Binomial GLMM}
\usage{
simDat17(
  nPops = 16,
  nYears = 10,
  mu.alpha = 0,
  mu.beta = -2,
  sigma.alpha = 1,
  sigma.beta = 1
)
}
\arguments{
\item{nPops}{Number of populations}

\item{nYears}{Number of years sampled in each population}

\item{mu.alpha}{Mean of random intercepts}

\item{mu.beta}{Mean of random slopes}

\item{sigma.alpha}{SD of random intercepts}

\item{sigma.beta}{SD of random slopes}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nYears}{Number of years sampled}
  \item{mu.alpha}{Mean of random intercepts}
  \item{sigma.alpha}{SD of random intercepts}
  \item{mu.beta}{Mean of random slopes}
  \item{sigma.beta}{SD of random slopes}
  \item{pop}{Population index}
  \item{precip}{Precipitation covariate values}
  \item{alpha}{Random intercepts}
  \item{beta}{Random slopes}
  \item{N}{Number of shrike pairs at each site}
  \item{C}{Number of successful shrike pairs at each site}
}
\description{
Simulate Number of successful pairs ~ precipitation regressions in 16 populations of woodchat shrikes
}
\examples{
library(lattice)
str(dat <- simDat17())      # Implicit default arguments (DOES NOT PRODUCE PLOT FOR SOME REASON)
xyplot(dat$C/dat$N ~ dat$precip | dat$pop, ylab = "Realized woodchat shrike breeding success ", 
       xlab = "Spring precipitation index", main = "Realized breeding success", pch = 16, cex = 1.2,
      col = rgb(0, 0, 0, 0.4))

# Revert to random intercept model. Increased sigma.alpha to emphasize the random intercepts part
str(dat <- simDat17(nPops = 16, sigma.alpha = 1, sigma.beta = 0))
xyplot(dat$C/dat$N ~ dat$precip | dat$pop, ylab = "Realized woodchat shrike breeding success ", 
       xlab = "Spring precipitation index", 
       main = "Realized breeding success (random-intercepts model)",
      pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4))

# Revert to random-effects one-way binomial ANOVA model: random intercepts, but zero slopes
str(dat <- simDat17(nPops = 16, sigma.alpha = 1, mu.beta = 0, sigma.beta = 0))
xyplot(dat$C/dat$N ~ dat$precip | dat$pop, ylab = "Realized woodchat shrike breeding success ", 
       xlab = "Spring precipitation index",
       main = "Realized breeding success (random-effects,
       one-way binomial ANOVA model)", 
       pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4))

# Revert to simple log-linear binomial (i.e., logistic) regression
#   (= no effects of pop on either intercepts or slopes)
str(dat <- simDat17(nPops = 16, sigma.alpha = 0, sigma.beta = 0))
xyplot(dat$C/dat$N ~ dat$precip | dat$pop, ylab = "Realized woodchat shrike breeding success ", 
       xlab = "Spring precipitation index", 
       main = "Realized breeding success\n(simple logistic regression model)", 
       pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4))

# Revert to binomial "model-of-the-mean": no effects of either population or precipitation
str(dat <- simDat17(nPops = 16, sigma.alpha = 0, mu.beta = 0, sigma.beta = 0))
xyplot(dat$C/dat$N ~ dat$precip | dat$pop, ylab = "Realized woodchat shrike breeding success ", 
       xlab = "Spring precipitation index", 
       main = "Realized breeding success (binomial 'model-of-the-mean')",
      pch = 16, cex = 1.2, col = rgb(0, 0, 0, 0.4))

}
\author{
Marc Kéry
}
