% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat19B}
\alias{simDat19B}
\title{Simulate data for Chapter 19B: Binomial N-mixture Model}
\usage{
simDat19B(
  nVisits = 3,
  alpha.lam = -3,
  beta1.lam = 8.5,
  beta2.lam = -3.5,
  alpha.p = 2,
  beta.p = -2,
  show.plot = TRUE
)
}
\arguments{
\item{nVisits}{Number of occasions, or visits per site}

\item{alpha.lam}{Intercept of the regression of log expected abundance on scaled elevation}

\item{beta1.lam}{Linear effect of scaled elevation on log expected abundance}

\item{beta2.lam}{Quadratic effect of scaled elevation on log expected abundance}

\item{alpha.p}{Intercept of the regression of logit detection on scaled elevation}

\item{beta.p}{Linear effect of scaled elevation on logit detection}

\item{show.plot}{Show plot of simulated output?}
}
\value{
A list of simulated data and parameters.
  \item{nSites}{Number of sites}
  \item{nVisits}{Number of visits to each site}
  \item{alpha.lam}{Abundance intercept}
  \item{beta1.lam}{Linear effect of elevation on abundance}
  \item{beta2.lam}{Quadratic effect of elevation on abundance}
  \item{alpha.p}{Detection intercept}
  \item{beta.p}{Linear effect of elevation on detection}
  \item{mhbElev}{Elevation covariate values}
  \item{mhbElevScaled}{Scaled elevation covariate values}
  \item{lambda}{Expected abundance for each site}
  \item{N}{True abundance at each site}
  \item{p}{Detection probability at each site}
  \item{C}{Observed repeated counts at each site}
  \item{nocc.true}{True number of occupied sites}
  \item{nocc.app}{Apparent number of occupied sites}
  \item{psi}{True proportion of occupied sites}
  \item{psi.app}{Apparent proportion of occupied sites}
  \item{opt.elev.true}{Optimal elevation value}
  \item{totalN.true}{True total population size}
  \item{totalN.app}{Apparent total population size}
}
\description{
Function simulates replicated count data as used in the bonus Chapter 19B
in the ASM book. Abundance, detection and count data simulation 
is undertaken for the approximate elevation of the actual sample of survey
sites in the Swiss breeding bird survey "Monitoring Häufige Brutvögel" (MHB).
Note there is no nSites argument, since this is given in the MHB survey at 267.
}
\examples{
# With implicit default function argument values
str(simDat19B())

# With explicit function argument values
str(simDat19B(nVisits = 3, alpha.lam = -3, beta1.lam = 8.5, beta2.lam = -3.5, 
    alpha.p = 2, beta.p = -2, show.plot = TRUE))

# No plots
str(simDat19B(show.plot = FALSE))

# More visits
str(simDat19B(nVisits = 10))

# A single visit at each site
str(simDat19B(nVisits = 1))

# Greater abundance
str(simDat19B(alpha.lam = 0))

# Much rarer abundance
str(simDat19B(alpha.lam = -5))

# No quadratic effect of elevation on abundance (only a linear one)
str(simDat19B(beta2.lam = 0))

# No effect of elevation at all on abundance
str(simDat19B(beta1.lam = 0, beta2.lam = 0))

# Higher detection probability (intercept at 0.9)
str(simDat19B(alpha.p = qlogis(0.9), beta.p = -2))

# Higher detection probability (intercept at 0.9) and no effect of elevation
str(simDat19B(alpha.p = qlogis(0.9), beta.p = 0))

# Perfect detection (p = 1)
str(simDat19B(alpha.p = 1000))

# Positive effect of elevation on detection probability (and lower intercept)
str(simDat19B(alpha.p = -2, beta.p = 2))

}
\author{
Marc Kéry
}
