% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat72}
\alias{simDat72}
\title{Simulate data for Chapter 7.2: ANOVA with fixed effects of population}
\usage{
simDat72(nPops = 5, nSample = 10, pop.means = c(50, 40, 45, 55, 60), sigma = 5)
}
\arguments{
\item{nPops}{Number of populations}

\item{nSample}{Samples from each population}

\item{pop.means}{Vector of mean length for each population}

\item{sigma}{Value for the residual standard deviation}
}
\value{
A list of simulated data and parameters.
  \item{nPops}{Number of populations}
  \item{nSample}{Number of samples per population}
  \item{pop.means}{Population means}
  \item{sigma}{Residual SD}
  \item{pop}{Indicator for population number}
  \item{eps}{Simulated residuals}
  \item{y}{Simulated lengths}
}
\description{
Simulate snout-vent length measurements of nSample smooth snakes in each of nPops populations
Data are simulated under the assumptions of a model with fixed effects of populations
}
\examples{
str(dat <- simDat72())      # Implicit default arguments

# More pops, fewer snakes in each
str(dat <- simDat72(nPops = 10, nSample = 5, pop.means = runif(10,20,60)))

# Revert to "model-of-the-mean" (larger sample size to minimize sampling variability)
str(dat <- simDat72(nSample = 1000, pop.means = rep(50, 5), sigma = 5))

}
\author{
Marc Kéry
}
