% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_model.R
\name{create_model_Unscaled_nuts}
\alias{create_model_Unscaled_nuts}
\title{Initialize an ATN model, following Schneider et al. 2016, Nature Communication}
\usage{
create_model_Unscaled_nuts(nb_s, nb_b, nb_n = 2, BM, fw)
}
\arguments{
\item{nb_s}{integer, number of total species.}

\item{nb_b}{integer, number of basal species.}

\item{nb_n}{integer, number of nutrients.}

\item{BM}{float vector, body mass of species.}

\item{fw}{binary adjacency matrix of the food web.}
}
\value{
An object of class \emph{ATN (Rcpp_parameters_prefs)}.
}
\description{
Initialize an ATN model, following Schneider et al. 2016, Nature Communication
}
\details{
A model is defined by the total number of species
(\emph{nb_s}), the number of basal species (\emph{nb_b}),
the number of nutrients (\emph{nb_n}), the body masses
 (\emph{BM}) of species, and the adjacency matrix (\emph{fw})
 representing species interactions.
Nutrients are not counted as species.
}
\examples{
library(ATNr)
set.seed(123)
n_species <- 50
n_basal <- 20
n_nutrients <- 2
masses <- sort(10^runif(n_species, 2, 6)) #body mass of species
L <- create_Lmatrix(masses, n_basal)
fw <- L
fw[fw > 0] <- 1
mod <- create_model_Unscaled_nuts(n_species, n_basal, n_nutrients, masses, fw)
}
