% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{new.mle}
\alias{new.mle}
\title{Maximum likelihood estimate for general discrete and continuous distributions}
\usage{
new.mle(x,r,p,alpha1,alpha2,n,lambda,mean,sigma,dist,lowerbound=0.01,upperbound=10000)
}
\arguments{
\item{x}{A vector of count data which should non-negative integers for discrete cases. Real valued random generation for continuous cases.}

\item{r}{An initial value for the number of success before which m failures are observed, where m is the element of x. Must be a positive number, but not required to be an integer.}

\item{p}{An initial value for the probability of success, should be a positive value within (0,1).}

\item{alpha1}{An initial value for the first shape parameter of beta distribution. Should be a positive number.}

\item{alpha2}{An initial value for the second shape parameter of beta distribution. Should be a positive number.}

\item{n}{An initial value for the number of trials. Must be a positive number, but not required to be an integer.}

\item{lambda}{An initial value for the rate. Must be a positive real number.}

\item{mean}{An initial value of the mean or expectation. A real number}

\item{sigma}{An initial value of the standard deviation. Must be a positive real number.}

\item{dist}{The distribution used to calculate the maximum likelihood estimate. Can be one of 'poisson', 'geometric', 'nb', 'nb1', 'bb', 'bb1', 'bnb', 'bnb1', 'normal', 'halfnormal', 'lognormal', 'exponential', which corresponds to Poisson geometric, negative binomial, negative binomial1, beta binomial, beta binomial1, beta negative binomial, beta negative binomial1, normal, half normal, log normal, and exponential distributions.}

\item{lowerbound}{A lower searching bound used in the optimization of likelihood function. Should be a small positive number. The default is 1e-2.}

\item{upperbound}{An upper searching bound used in the optimization of likelihood function. Should be a large positive number. The default is 1e4.}
}
\value{
A row vector containing the maximum likelihood estimate of the unknown parameters and the corresponding value of negative log likelihood.

  If dist = poisson, the following values are returned:
\itemize{
\item lambda: the maximum likelihood estimate of \eqn{\lambda}.
\item loglik: the value of negative log likelihood with maximum likelihood estimate plugged-in.}
If dist = geometric, the following values are returned:
\itemize{
\item p: the maximum likelihood estimate of p.
\item loglik: the value of negative log likelihood with maximum likelihood estimate plugged-in.}
If dist = nb, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of r.
\item p: the maximum likelihood estimate of p.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = nb1, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of rounded r (returns integer estimate).
\item p: the maximum likelihood estimate of p.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bb, the following values are returned:
\itemize{
\item n: the maximum likelihood estimate of n.
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bb1, the following values are returned:
\itemize{
\item n: the maximum likelihood estimate of rounded n (returns integer estimate).
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bnb, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of r.
\item a lpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = bnb1, the following values are returned:
\itemize{
\item r: the maximum likelihood estimate of rounded r (returns integer estimate).
\item alpha1: the maximum likelihood estimate of \eqn{\alpha_1}.
\item alpha2: the maximum likelihood estimate of \eqn{\alpha_2}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = normal, the following values are returned:
\itemize{
\item mean: the maximum likelihood estimate of \eqn{\mu}.
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = lognormal, the following values are returned:
\itemize{
\item mean: the maximum likelihood estimate of \eqn{\mu}.
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = halfnormal, the following values are returned:
\itemize{
\item sigma: the maximum likelihood estimate of \eqn{\sigma}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
If dist = exponential, the following values are returned:
\itemize{
\item lambda: the maximum likelihood estimate of \eqn{\lambda}.
\item loglik: the value of negative log likelihood with maximum likelihood estimates plugged-in.}
}
\description{
calculate the Maximum likelihood estimate and the corresponding negative log likelihood value for
 general Poisson, geometric, negative binomial, negative binomial1,
 beta binomial, beta binomial1, beta negative binomial, beta negative binomial1,
 normal, half normal, log normal, and exponential distributions.
}
\details{
new.mle calculate Maximum likelihood estimate and corresponding negative log likelihood
 of general Poisson, geometric, negative binomial, negative binomial1,
 beta binomial, beta binomial1, beta negative binomial, beta negative binomial1,
 normal, half normal, log normal, and exponential distributions.
}
\examples{
set.seed(001)
x1=stats::rpois(1000,lambda=10)
new.mle(x1,lambda=3,dist="poisson")                         #9.776 -2611.242
x2=stats::rgeom(1000,prob=0.2)
new.mle(x2,p=0.5,dist="geometric")                          #0.1963865 -2522.333
x3=stats::rnbinom(1000,size=5,prob=0.3)
new.mle(x3,r=2,p=0.6,dist="nb")                             #5.113298 0.3004412 -3186.163
new.mle(x3,r=2,p=0.6,dist="nb1")                            #5 0.299904 -3202.223
x4=extraDistr::rbbinom(1000,size=4,alpha=2,beta=3)
new.mle(x4,n=10,alpha1=3,alpha2=4,dist="bb")                #3.99 1.78774 2.680009 -1533.982
new.mle(x4,n=10,alpha1=3,alpha2=4,dist="bb1")               #4 1.800849 2.711264 -1534.314
x5=extraDistr::rbnbinom(1000, size=5, alpha=3,beta=3)
new.mle(x5,r=5,alpha1=3,alpha2=4,dist="bnb")                #5.472647 3.008349 2.692704 -3014.372
new.mle(x5,r=5,alpha1=3,alpha2=4,dist="bnb1")               #5 2.962727 2.884826 -3014.379
x6=stats::rnorm(1000,mean=10,sd=2)
new.mle(x6,mean=2,sigma=1,dist="normal")                    #9.976704 2.068796 -2145.906
x7=stats::rlnorm(1000, meanlog = 1, sdlog = 4)
new.mle(x7,mean=2,sigma=2,dist="lognormal")                 #0.9681913 3.299503 -3076.156
x8=extraDistr::rhnorm(1000, sigma = 3)
new.mle(x8,sigma=2,dist="halfnormal")                       #3.103392 -1858.287
x9=stats::rexp(1000,rate=1.5)
new.mle(x9,lambda=3,dist="exponential")                     #1.454471 -625.3576
}
\references{
\itemize{\item H. Aldirawi, J. Yang, A. A. Metwally (2019). Identifying Appropriate Probabilistic Models for Sparse Discrete Omics Data, accepted for publication in 2019 IEEE EMBS International Conference on Biomedical & Health Informatics (BHI).}
}
