% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTemporalData.r
\name{getTemporalData}
\alias{getTemporalData}
\title{getTemporalData}
\usage{
getTemporalData(
  connectionDetails,
  cdmDatabaseSchema,
  resultsDatabaseSchema,
  analysisIds = NULL,
  conceptId = NULL
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package.}

\item{cdmDatabaseSchema}{Fully qualified name of database schema that contains OMOP CDM
schema. On SQL Server, this should specifiy both the database and the
schema, so for example, on SQL Server, 'cdm_instance.dbo'.}

\item{resultsDatabaseSchema}{Fully qualified name of database schema that we can write final
results to. Default is cdmDatabaseSchema. On SQL Server, this should
specifiy both the database and the schema, so for example, on SQL
Server, 'cdm_results.dbo'.}

\item{analysisIds}{(OPTIONAL) A vector containing the set of Achilles analysisIds for
which results will be returned. The following are supported:
\code{202,402,602,702,802,1802,2102}. If not specified, data for all
analysis will be returned. Ignored if \code{conceptId} is given.}

\item{conceptId}{(OPTIONAL) A SNOMED concept_id from the \code{CONCEPT} table for
which a monthly Achilles analysis exists. If not specified, all
concepts for a given analysis will be returned.}
}
\value{
A data frame of query results from \code{DatabaseConnector}
}
\description{
\code{getTemporalData} Retrieve specific monthly analyses data to support temporal
characterization.
}
\details{
\code{getTemporalData} Assumes \code{achilles} has been run. \preformatted{Currently supported
Achilles monthly analyses are: 202 - Visit Occurrence 402 - Condition occurrence 602 - Procedure
Occurrence 702 - Drug Exposure 802 - Observation 1802 - Measurement 2102 - Device}
}
\examples{
\dontrun{
pneumonia <- 255848
monthlyResults <- getTemporalData(connectionDetails = connectionDetails,
                                  cdmDatabaseSchema = "cdm",

  resultsDatabaseSchema = "results", conceptId = pneumonia)
}

}
