% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wear_flag.R
\name{wear_flag}
\alias{wear_flag}
\title{Create Wear/Nonwear Flags}
\usage{
wear_flag(count.data, start = "05:00", end = "23:00")
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n*1442 containing the 1440 minute activity data for all n subject days.
The first two columns have to be ID and Day.}

\item{start}{start time, a string in the format of 24hr, e.g. "05:00"; defaults to "05:00".}

\item{end}{end time, a string in the format of 24hr, e.g. "23:00"; defaults to "23:00"}
}
\value{
A \code{data.frame} with same dimension and column name as the \code{count.data}, with 0/1 as the elments
reprensting wear, nonwear respectively.
}
\description{
Determine during which time period, subject should wear the device.
It is preferable that user provide their own wear/non wear flag which should has the same dimension
as the activity data. This function provide wear/non wear flag based on time of day.
}
\details{
Fragmentation metrics are usually defined when subject is awake. The \code{weartime} provide time periods on which those features should be extracted.
This can be also used as indication of wake/sleep.
}
\examples{
data(example_activity_data)
count = example_activity_data$count
weartime = wear_flag(count.data = count)



}
