% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SleepEstEachDay.R
\name{SleepEstEachDay}
\alias{SleepEstEachDay}
\title{Daily sleep estimate}
\usage{
SleepEstEachDay(
  datain,
  f = 1,
  id = NA,
  Y_name = "max_count",
  T = 0.4,
  nonwear_detect = FALSE,
  wear_mins = 120,
  S = 3,
  NoPA_cut = 0.7,
  sleep_mins = 20,
  wake_mins = 180,
  nap_mins = 20,
  UseDiary = FALSE,
  diary_data = c(),
  CommonBedTime = "22:00:00",
  CommonWakeTime = "8:00:00",
  tz = "GMT"
)
}
\arguments{
\item{datain}{input accelerometry dataset, must be tibble, data frame, etc.}

\item{f}{cost function indicator}

\item{id}{subject id}

\item{Y_name}{column name of the activity count data to be used in analysis, for example max count of x, y, z axes or vector magnitude}

\item{T}{threshold percentile of activity level}

\item{nonwear_detect}{flag indicating use of nonwear detection algorithm, default is FALSE}

\item{wear_mins}{threshold number of minutes to define wear segment}

\item{S}{number of segments per hour}

\item{NoPA_cut}{percent of 0 counts to define NoPA segments}

\item{sleep_mins}{threshold number of minutes to define sleep segment}

\item{wake_mins}{threshold number of minutes to define wake segment}

\item{nap_mins}{threshold number of minutes to define nap segment}

\item{UseDiary}{flag indicating if diary data to be used, default is FALSE}

\item{diary_data}{diary data, must be a data frame}

\item{CommonBedTime}{in-bed time if no diary data, default is "22:00:00"}

\item{CommonWakeTime}{out-bed time if no diary data, default is "8:00:00"}

\item{tz}{timezone, default is GMT}
}
\value{
list containing a data frame of summary sleep data
}
\description{
Obtain sleep data from accelerometer data
}
\examples{
data("AccelData")

AccelData <-
ChangeTimeVar(AccelData, col_idx = 1, format = "\%m/\%d/\%Y \%H:\%M")

SleepEstEachDay(AccelData, Y_name = "VM")

data("AccelData")

AccelData <-
ChangeTimeVar(AccelData, col_idx = 1, format = "\%m/\%d/\%Y \%H:\%M")

SleepEstEachDay(AccelData, Y_name = "VM", nonwear_detect = TRUE)

data("AccelData")
data("SleepDiary1Day")

SleepDiary1Day <-
ChangeTimeVar(
SleepDiary1Day,
col_idx = c(1,2),
format = "\%m/\%d/\%Y \%H:\%M")

AccelData <-
ChangeTimeVar(AccelData, col_idx = 1, format = "\%m/\%d/\%Y \%H:\%M")

SleepEstEachDay(
AccelData,
f = 2,
Y_name = "VM",
T = 0,
nonwear_detect = TRUE,
S = 2,
NoPA_cut = 0.45,
sleep_mins = 5,
UseDiary = TRUE,
diary_data = SleepDiary1Day
)

}
