set.seed(123)
dat <- simulate_stream(T0 = 10, TT = 30, d = 3, T_max_IC = 10, T_min_IC = 5)
test_that("active_learning_pHMM produces decisions and scores", {
  res <- active_learning_pHMM(
    y = dat$y,
    true_x = dat$x,
    T0 = 10,
    B = 0.1,
    weight_exploration = 0.5,
    verbose = F
  )

  expect_type(res, "list")
  expect_true(all(c("decision", "xlabeled", "xhat", "scores") %in% names(res)))
  expect_equal(length(res$decision), nrow(dat$y))
  expect_true("f1" %in% names(res$scores))
})

test_that("active_learning_pHMM runs with small budget", {
  res <- active_learning_pHMM(y = dat$y, true_x = dat$x, T0 = 10, B = 0.01)
  expect_type(res$decision, "character")
  expect_lte(sum(res$decision %in% c("label_exploitation","label_exploration")), 1)
})
