% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rASS.R
\name{rASS}
\alias{rASS}
\title{Adaptive Slice Sampling Algorithm With Stepping-Out Procedures}
\usage{
rASS(n, x0 = 0, formula, w = 3)
}
\arguments{
\item{n}{Desired sample size;}

\item{x0}{Initial value;}

\item{formula}{Target density function p(x);}

\item{w}{Length of the coverage interval.}
}
\description{
rASS generates a sequence of random numbers by the adaptive slice sampling algorithm with stepping-out procedures.
}
\examples{

# Example 1: Sampling from exponential distribution with bounded domain
x<-rASS(100,-1,"1.114283*exp(-(4-x^2)^2)",3)
plot(density(x))

}
\references{
Neal R M. Slice sampling - Rejoinder[J]. Annals of Statistics, 2003, 31(3):758-767.
}
\author{
Dong Zhang <\url{dzhang0716@126.com}>
}
