% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/250605_axDistmap_v0.99.6.R
\name{axDistmap}
\alias{axDistmap}
\title{Create distance map and binary image from TIFF image file}
\usage{
axDistmap(
  subBack = 30,
  resizeW = 900,
  binaryImg = FALSE,
  allFeatures = FALSE,
  imgType = "tiff",
  folder_paths = NULL,
  output_path = tempdir()
)
}
\arguments{
\item{subBack}{Numeric. Area threshold in pixels: connected components (objects) with area less than or equal to this value will be removed as background. (default: 30).}

\item{resizeW}{Numeric. Target width in pixels for resizing each imported image (default: 900, recommended > 700).
Larger values preserve more image detail and may improve analysis accuracy, but also increase memory usage and computation time.
Note that while higher resolutions can enhance result quality, beyond a certain point, further increasing the image size yields diminishing returns in accuracy but continues to increase computational cost.}

\item{binaryImg}{Logical. If TRUE, exports binary image files (default: FALSE).}

\item{allFeatures}{Logical. If TRUE, exports data of all computed features (default: FALSE).}

\item{imgType}{Character. Output image format: "png", "jpg", or "tiff" (default: "tiff").}

\item{folder_paths}{Character vector. A character vector of folder paths to process. If NULL, a folder selection dialog will be shown. (default: NULL).}

\item{output_path}{Character vector. A character vector of folder paths to process. If NULL, a folder selection dialog will be shown. (default: NULL).}
}
\value{
This function doesn't return a value directly, but produces the following outputs:
\itemize{
\item A distance map image file (format specified by \code{imgType})
\item A text file containing computed image features (named "'original_filename'_'current_date'_ImageData.txt")
\item (Optional) A binary image file if \code{binaryImg = TRUE} (format specified by \code{imgType})
}
}
\description{
\code{axDistmap} processes TIFF image files to create distance maps and optionally binary images.
It also computes various image features and exports them as a text file.
}
\details{
The function performs the following steps:
\enumerate{
\item Reads and resizes the input TIFF image
\item Applies various image processing techniques (contrast adjustment, filtering, thresholding)
\item Computes a distance map
\item Computes shape, Haralick, and moment features
\item Exports the processed images as image files
\item Exports the computed features as a tab-separated text file
}
}
\note{
\itemize{
\item The function will prompt the user to select a directory containing TIFF files.
\item It processes all TIFF files in the selected directory.
\item Once there are no unprocessed files left in the selected directory, the function will prompt
the user to choose whether to process another folder.
\item Processing will continue until the user cancels the operation.
\item Output files (images and feature data) are saved in the same directory as the input files.
\item The feature data text file is named using the format: "'original_filename'_'current_date'_ImageData.txt"
\item If allFeatures = FALSE, only features required for the support vector machine learning in this package are exported.
\item If allFeatures = TRUE, all features from EBImage package plus Circularity are exported.
}
}
\section{Feature Export}{

The function always exports computed features as a text file.
If allFeatures = FALSE, it exports a subset of features including:
\itemize{
\item s.area (EBImage::computeFeatures.shape)
\item m.eccentricity (EBImage::computeFeatures.moment)
\item s.radius.sd (EBImage::computeFeatures.shape)
\item h.sva.s2 (EBImage::computeFeatures.haralick)
\item h.idm.s1 (EBImage::computeFeatures.haralick)
\item h.sen.s1 (EBImage::computeFeatures.haralick)
\item m.majoraxis (EBImage::computeFeatures.moment)
}

If allFeatures = TRUE, it exports all computed features from EBImage's computeFeatures
functions (shape, moment, and haralick) plus an additional 'Cir' feature.
The 'Cir' feature represents Circularity and is calculated as:
Cir = (s.area * pi * 4) / (s.perimeter^2), where s.area and s.perimeter are from
EBImage::computeFeatures.shape.
}

\examples{

# Basic usage with default parameters
# Exports only features needed for SVM learning
# NOTE: This example requires a GUI environment for interactive folder selection.
if (interactive()){
axDistmap()
}

# Create binary images and export all EBImage features plus Circularity as PNG
\donttest{
img_dir <- system.file("extdata", "Degenerate_Images", package = "AiES")
axDistmap(subBack = 50, binaryImg = TRUE, allFeatures = TRUE, imgType = "png",
folder_paths = img_dir, output_path = tempdir())
# Export all EBImage features plus Circularity without creating binary images
img_dir <- system.file("extdata", "Degenerate_Images", package = "AiES")
axDistmap(binaryImg = FALSE, allFeatures = TRUE,folder_paths = img_dir, output_path = tempdir())
}

# Process images and export as TIFF without binary images
# Process with custom image resize and background threshold
# Only exports features needed for SVM learning
img_dir <- system.file("extdata", "Degenerate_Images", package = "AiES")
axDistmap(subBack = 20, resizeW = 300, binaryImg = FALSE, allFeatures = FALSE, imgType = "png",
folder_paths = img_dir, output_path = tempdir())


}
