% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AirMonitor-package.R
\docType{package}
\name{AirMonitor-package}
\alias{AirMonitor}
\alias{AirMonitor-package}
\title{AirMonitor: Air Quality Data Analysis}
\description{
Utilities for working with hourly air quality monitoring data with a focus on small particulates (PM2.5). A compact data model is structured as a list with two dataframes. A 'meta' dataframe contains spatial and measuring device metadata associated with deployments at known locations. A 'data' dataframe contains a 'datetime' column followed by columns of measurements associated with each "device-deployment". Algorithms to calculate NowCast and the associated Air Quality Index (AQI) are defined at the US Environmental Projection Agency AirNow program: \url{https://document.airnow.gov/technical-assistance-document-for-the-reporting-of-daily-air-quailty.pdf}.

\code{
Utilities for working with hourly air quality monitoring data
with a focus on small particulates (PM2.5). A compact data model is
structured as a list with two dataframes. A 'meta' dataframe contains
spatial and measuring device metadata associated with deployments at known
locations. A 'data' dataframe contains a 'datetime' column followed by
columns of measurements associated with each "device-deployment".
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/MazamaScience/AirMonitor}
  \item \url{https://mazamascience.github.io/AirMonitor/}
  \item Report bugs at \url{https://github.com/MazamaScience/AirMonitor/issues}
}

}
\author{
\strong{Maintainer}: Jonathan Callahan \email{jonathan.s.callahan@gmail.com}

Other contributors:
\itemize{
  \item Spencer Pease \email{spencerpease618@gmail.com} [contributor]
  \item Hans Martin \email{hansmrtn@gmail.com} [contributor]
  \item Rex Thompson \email{rexs.thompson@gmail.com} [contributor]
}

}
\keyword{internal}
