% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_slice.R
\name{monitor_slice_head}
\alias{monitor_slice_head}
\alias{monitor_slice_tail}
\title{Subset time series based on their position within an \emph{mts_monitor} object}
\usage{
monitor_slice_head(monitor, n = 5)

monitor_slice_tail(monitor, n = 5)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{n}{Number of rows of \code{monitor$meta} to select.}
}
\value{
A subset of the incoming \emph{mts_monitor} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
An \emph{mts_monitor} object is reduced so as to contain only
the first or last \code{n} timeseries. These functions work similarly to
\code{\link[dplyr:slice_head]{dplyr::slice_head}} and
\code{\link[dplyr:slice_tail]{dplyr::slice_tail}}
but apply to both dataframes in the \emph{mts_monitor} object.

This is primarily useful when the \emph{mts_monitor} object has been ordered
by a previous call to \code{\link{monitor_arrange}} or by some other means.

\code{monitor_slice_head()} selects the first and \code{monitor_slice_tail()}
the last timeseries in the object.
}
\examples{
library(AirMonitor)

# Find lowest elevation sites
Camp_Fire \%>\%
  monitor_filter(!is.na(elevation)) \%>\%
  monitor_arrange(elevation) \%>\%
  monitor_slice_head(n = 5) \%>\%
  monitor_getMeta() \%>\%
  dplyr::select(elevation, locationName)

# Find highest elevation sites
Camp_Fire \%>\%
  monitor_filterMeta(!is.na(elevation)) \%>\%
  monitor_arrange(elevation) \%>\%
  monitor_slice_tail(n = 5) \%>\%
  monitor_getMeta() \%>\%
  dplyr::select(elevation, locationName)

}
