% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Air_methods.R
\name{newton}
\alias{newton}
\title{Newton-Raphson root finder}
\usage{
newton(f, fp, x, tol = 0.001, m = 100)
}
\arguments{
\item{f}{Function whose root is sought.}

\item{fp}{Derivative function of \code{f}.}

\item{x}{Numeric starting value.}

\item{tol}{Convergence tolerance (default \code{1e-3}).}

\item{m}{Maximum number of iterations (default \eqn{100}).}
}
\value{
The estimated root.
}
\description{
Newton-Raphson root finder
}
\details{
Iterates \eqn{x_{new} = x - f(x)/f'(x)} until the change is below \code{tol}
or \code{m} iterations are reached (then issues a warning).
}
\examples{
# Solve x^2 - 2 = 0
newton(function(x) x^2 - 2, function(x) 2*x, 1)
}
