% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Air_methods.R
\name{summary.AirResult}
\alias{summary.AirResult}
\title{Summarise an \code{AirResult} Object}
\usage{
\method{summary}{AirResult}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"AirResult"}.}

\item{...}{Additional arguments (ignored; included for S3 compatibility).}
}
\value{
Invisibly returns \code{object}. The function is invoked for
its printing side-effect.
}
\description{
Produces a compact, human-readable summary of the ranking results
returned by \code{\link{Air}}.
}
\examples{
set.seed(314)
X <- matrix(rnorm(500), 50, 100)
y <- X[, 1] - 2*X[, 3] + rnorm(50)
res <- Air(X, y, penalty_type = "both")
summary(res)

}
