% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSfaces.R
\name{NSfaces}
\alias{NSfaces}
\title{Face games associated with an airport problem}
\usage{
NSfaces(c, R)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{R}{A numeric vector representing the agents forming the coalition}
}
\value{
A numeric matrix with two rows representing the decomposition of the \eqn{R}-face game:
\item{\code{[1,]}}{The first row is obtained by setting the cost of a specific coalition to zero while retaining the cost parameters of the complementary coalition.}
\item{\code{[2,]}}{The second row is derived by subtracting the highest cost in the complementary coalition from each agent's cost, or setting it to zero if the result is negative.}
}
\description{
\code{NSfaces} determines the airport problems defining the two components of the decomposition
of one specific face game.
}
\details{
Let \eqn{c\in C^N} be an airport problem and \eqn{v\in G^N} its associated cost game, for each non-empty proper coalition \eqn{R\in 2^N\backslash\{\emptyset, N\}}
define the \eqn{N\backslash R}-face of Core\eqn{(v)} as the set
\deqn{
F_{N\backslash R}(c)=\text{Core}(v)\cap\{x\in \mathbb{R}^N:x(R)=v(R)\}.
}
Also, the \eqn{N\backslash R}-face game \eqn{v_{F_{N\backslash R}}\in G^N} is given by \eqn{v_{F_{N\backslash R}}(S)=v(S\cup R)-v(R)+v(S\cap R),\ S\in 2^N}.
It turns out that \eqn{F_{N\backslash R}(c)=\text{Core}(v_{F_{N\backslash R}})}, the \eqn{N\backslash R}-face of the core of the associated cost game is the
core of the \eqn{N\backslash R}-face game. Let \eqn{r\in N} such that \eqn{c_r=v(R)=\text{max}\{c_i:i\in R\}} and denote \eqn{R_+=\{k\in N:k>r\}}.
Consider the airport problems
\deqn{
c_{|R}=(0_{N\backslash R}, c_R)\in C^N \text{ and } c_{|R_+}=(0_{N\backslash R_+},c_{r+1}-c_r,\dots,c_n-c_r)\in C^N
}
with associated games \eqn{v^{|R}\in G^N} and \eqn{v^{|R_+}\in G^N}, respectively. It is easy to see that the \eqn{N\backslash R}-face game
\eqn{v_{F_{N\backslash R}}\in G^N} is decomposable with respect to the partition \eqn{R,N\backslash R} and its components are
\eqn{v^{|R}} and \eqn{v^{|R_+}}. Moreover,
\deqn{
F_{N\backslash R}(c)=NS(c_R)\times NS(c_{r+1}-c_r,\dots,c_n-c_r)\times 0_{N\backslash(R\cup R_+)}.
}
Therefore, the components of the face games of the associated cost game are associated cost games themselves.
In the \eqn{N\backslash R}-face game, the players of \eqn{R} play the game associated with the problem where
the agents of \eqn{R} keep their cost parameters while the cost parameter of the agents in \eqn{N\backslash R} is null.
On the other hand, since the players of \eqn{R} already share \eqn{c_r=v(R)} among themselves, the players of
\eqn{N\backslash R} with an initial cost lower than \eqn{c_r} now have their cost parameter equal to zero while the others
see their cost reduced by \eqn{c_r}.
}
\examples{
c <- c(1, 3, 7, 10) # Cost vector
R <- c(3, 4) # Coalition of agents
NSfaces(c, R) # Components of the face game

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

González-Díaz, J. and Sánchez-Rodríguez, E. (2008). Cores of convex and strictly convex games. \emph{Games and Economic Behavior}, 62, 100-105.

Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2020). The boundary of the core of a balanced game: faces games.
\emph{International Journal of Game Theory}, 49(2), 579-599.
}
\seealso{
\code{\link{NScheck}}, \code{\link{NSstructure}}, \code{\link{NSset}}, \code{\link{hierarchicalrule}}
}
