# AlgeriAPIs

[![License: MIT](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

The `AlgeriAPIs` package provides a unified interface to access open data from the **World Bank API** and the **REST Countries API**, with a focus on **Algeria**. It allows users to retrieve real-time or historical information on topics such as economic indicators, population statistics, and key geopolitical details.

`AlgeriAPIs` enables users to query data in a reproducible way and is designed for researchers, analysts, and developers who require reliable and programmatic access to Algerian data through established APIs.

## Installation

You can install the `AlgeriAPIs` package from CRAN with the following R function:

```R

install.packages("AlgeriAPIs")

```


You can install `AlgeriAPIs` package from its Github repository with the following R function:

```R

# Make sure the 'devtools' package is installed before using install_github()


devtools::install_github("lightbluetitan/algeriapis")

```


## Usage

After installation, load the package and start exploring and using its functions and datasets.

```R

library(AlgeriAPIs)

```

### AlgeriAPIs Functions

Below is a list of the main functions included in the package:

- `get_algeria_child_mortality()`: Get Algeria’s Under-5 Mortality Rate data from the World Bank.

- `get_algeria_cpi()`: Get Algeria’s Consumer Price Index (2010 = 100) data from the World Bank.

- `get_algeria_energy_use()`: Get Algeria’s Energy Use (kg of oil equivalent per capita) data from the World Bank.

- `get_algeria_gdp()`: Get Algeria’s GDP (current US$) data from the World Bank.

- `get_algeria_holidays()`: Get official public holidays in Algeria for a given year, e.g., `get_algeria_holidays(2025)`.

- `get_algeria_hospital_beds()`: Get Algeria’s Hospital Beds (per 1,000 people) data from the World Bank.

- `get_algeria_literacy_rate()`: Get Algeria’s Adult Literacy Rate data from the World Bank.

- `get_algeria_life_expectancy()`: Get Algeria’s Life Expectancy at Birth data from the World Bank.

- `get_algeria_population()`: Get Algeria’s Total Population data from the World Bank.

- `get_algeria_unemployment()`: Get Algeria’s Total Unemployment Rate data from the World Bank.

- `get_country_info_dz()`: Get key country information for Algeria.

- `view_datasets_AlgeriAPIs()`: View available curated datasets included in AlgeriAPIs.

## Example Code:

```R

# Load the package

library(AlgeriAPIs)

# Retrieves essential information about Algeria

get_country_info_dz()

# Get Algeria's Population (Total) from World Bank

get_algeria_population()

# Get Algeria’s GDP (current US$)

get_algeria_gdp()

```
