% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{CollapseGeno}
\alias{CollapseGeno}
\title{Collapse Variants}
\usage{
CollapseGeno(anno, geno, min_mac = 11)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{geno}{(n x snps) genotype matrix.}

\item{min_mac}{Minimum minor allele count (MAC) for retention as an
individual variant. Variants with a MAC strictly less than the minimum
MAC will be collapsed into an aggregated variant, separately within
each annotation category.}
}
\value{
List containing the collapsed genotypes \code{geno} and corresponding
annotations \code{anno}, plus a data.frame \code{vars} specifying which variants
were collapsed within each annotation category.
}
\description{
Collapse variants with minor allele counts below the \code{min_mac} threshold
into an aggregated variant, separately within each variant category. Note
that the ordering of the variants will change, and that collapsing does not
guarantee that the resulting aggregate variant will itself have a
MAC greater than or equal to \code{min_mac}.
}
