% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMethods.R
\name{mapLevels}
\alias{mapLevels}
\alias{mapLevels.default}
\alias{mapLevels.character}
\alias{mapLevels.list}
\alias{mapLevels.data.frame}
\alias{print.levelsMap}
\alias{print.listLevelsMap}
\alias{is.levelsMap}
\alias{is.listLevelsMap}
\alias{.checkLevelsMap}
\alias{.checkListLevelsMap}
\alias{"[.levelsMap"}
\alias{"[.listLevelsMap"}
\alias{c.levelsMap}
\alias{c.listLevelsMap}
\alias{unique.levelsMap}
\alias{sort.levelsMap}
\alias{mapLevels<-}
\alias{mapLevels<-.default}
\alias{mapLevels<-.factor}
\alias{mapLevels<-.character}
\alias{mapLevels<-.list}
\alias{mapLevels<-.data.frame}
\alias{mapLevels.factor}
\alias{.unlistLevelsMap}
\alias{[.levelsMap}
\alias{[.listLevelsMap}
\alias{.isCharacterMap}
\alias{as.levelsMap}
\alias{as.listLevelsMap}
\title{Mapping levels}
\usage{
mapLevels(x, codes=TRUE, sort=TRUE, drop=FALSE, combine=FALSE, \dots)

mapLevels(x) <- value

\method{mapLevels}{default}(x, codes, sort, drop, combine, ...)

\method{mapLevels}{character}(x, codes, sort, drop, combine, ...)

\method{mapLevels}{factor}(x, codes, sort, drop, combine, ...)

\method{mapLevels}{list}(x, codes, sort, drop, combine, ...)

\method{mapLevels}{data.frame}(x, codes, sort, drop, combine, ...)

.unlistLevelsMap(x, ind = FALSE)

\method{print}{levelsMap}(x, ...)

\method{print}{listLevelsMap}(x, ...)

\method{[}{levelsMap}(x, i)

\method{[}{listLevelsMap}(x, i)

is.levelsMap(x)

is.listLevelsMap(x)

.isCharacterMap(x)

as.levelsMap(x, check = TRUE, ...)

as.listLevelsMap(x, check = TRUE)

.checkLevelsMap(x, method)

.checkListLevelsMap(x, method)

\method{c}{levelsMap}(..., sort = TRUE, recursive = FALSE)

\method{c}{listLevelsMap}(..., sort = TRUE, recursive = FALSE)

\method{sort}{levelsMap}(x, decreasing = FALSE, na.last = TRUE, ...)

\method{unique}{levelsMap}(x, incomparables = FALSE, ...)

mapLevels(x) <- value

\method{mapLevels}{default}(x) <- value

\method{mapLevels}{list}(x) <- value

\method{mapLevels}{data.frame}(x) <- value
}
\arguments{
\item{x}{object whose levels will be mapped, look into details \code{codes} boolean,
create integer levelsMap (with internal codes) or character levelsMap (with level names)}

\item{codes}{boolean, create integer levelsMap (with internal codes) or character levelsMap (with level names)}

\item{sort}{boolean, sort levels of character \code{x}, look into details}

\item{drop}{boolean, drop unused levels}

\item{combine}{boolean, combine levels, look into details}

\item{...}{additional arguments for \code{sort}}

\item{value}{levelsMap or listLevelsMap, output of \code{mapLevels} methods or constructed by user, look into details}
}
\description{
\code{mapLevels} produces a map with information on levels and/or internal integer codes. As such can be conveniently used to store level mapping when one needs to work with internal codes of a factor and later transfrorm back to factor or when working with several factors that should have the same levels and therefore the same internal coding.
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}}
}
\author{
Gregor Gorjanc
}
\keyword{internal}
