% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{rawToAmigaBitmapFont}
\alias{rawToAmigaBitmapFont}
\title{Coerce raw data into an AmigaBitmapFont class object}
\usage{
rawToAmigaBitmapFont(x, ...)
}
\arguments{
\item{x}{An \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} object which needs to be converted
into \code{raw} data.}

\item{...}{Currently ignored.}
}
\value{
A \code{vector} of \code{raw} data representing \code{x}.
}
\description{
\code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} objects are comprehensive representations of binary Amiga
font subset files. The file name is usually simply a numeric number
indicating the font height in pixels. Use this function to convert
\code{raw} content from such a file to an \code{\link[=AmigaBitmapFont]{AmigaBitmapFont()}} object.
}
\details{
This function converts \code{raw} data as stored in font bitmap
files. These files are stored in subdirectories with the font's
name and usually have the font height in pixels as file name.
This function is effectively the inverse of \code{\link[=as.raw]{as.raw()}}.
}
\examples{
## first create raw data that can be converted into a AmigaBitmapFont
data(font_example)
font.raw <- as.raw(getAmigaBitmapFont(font_example, 9))

## Convert it back into an AmigaBitmapFont object:
font <- rawToAmigaBitmapFont(font.raw)
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{write.AmigaBitmapFont}()}

Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{colourToAmigaRaw}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasicShape}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaIcon}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{raw.operations}
