% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{getExpressionEstimates}
\alias{getExpressionEstimates}
\title{Returns the estimated phi posterior for a gene}
\usage{
getExpressionEstimates(
  parameter,
  gene.index,
  samples,
  quantiles = c(0.025, 0.975),
  genome = NULL
)
}
\arguments{
\item{parameter}{on object created by \code{initializeParameterObject}.}

\item{gene.index}{a integer or vector of integers representing the gene(s) of interesst.}

\item{samples}{number of samples for the posterior estimate}

\item{quantiles}{vector of quantiles, (default: c(0.025, 0.975))}

\item{genome}{if genome is given, then will include gene ids in output (default is NULL)}
}
\value{
returns a vector with the mixture assignment of each gene corresbonding to \code{gene.index} in the same order as the genome.
}
\description{
Posterior estimates for the phi value of specified genes
}
\details{
The returned vector is unnamed as gene ids are only stored in the \code{genome} object, 
but the \code{gene.index} vector can be used to match the assignment to the genome.
}
\examples{
 
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- c(rep(1,floor(length(genome)/2)),rep(2,ceiling(length(genome)/2)))
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
model <- initializeModelObject(parameter = parameter, model = "ROC")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE,
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)

# get the estimated expression values for all genes based on the mixture 
# they are assigned to at each step
estimatedExpression <- getExpressionEstimates(parameter, 1:length(genome), 1000)
}

}
