% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_functions.R
\name{import_seurat_scANANSE}
\alias{import_seurat_scANANSE}
\title{import_seurat_scANANSE}
\usage{
import_seurat_scANANSE(
  seurat_object,
  cluster_id = "seurat_clusters",
  anansnake_inf_dir = "None",
  return_df = FALSE
)
}
\arguments{
\item{seurat_object}{seurat object}

\item{cluster_id}{ID used for finding clusters of cells}

\item{anansnake_inf_dir}{influence directory generated by anansnake}

\item{return_df}{return both the seurat object and a dataframe with influence scores as a list}
}
\value{
seurat object with the influence scores addes as an assay
}
\description{
import the influences from a anansnake directory into a seurat object
}
\examples{
sce_small <- readRDS(system.file("extdata","sce_small.Rds",package = 'AnanseSeurat'))
infdir <- system.file("extdata","influence",package = 'AnanseSeurat')
sce_small <- import_seurat_scANANSE(sce_small, anansnake_inf_dir = infdir)
}
