% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot_AncestryMapper.R
\name{plotAMids}
\alias{plotAMids}
\title{Visualises genetic distances.}
\usage{
plotAMids(AMids, phenoFile, columnPlot = "I", quantilePlot = TRUE,
  colorPlot = "BlBrewer", sepLinesPop = TRUE, plotIndNames = FALSE,
  legColor = TRUE, legRef = TRUE, legPheno = TRUE, legAxisPop = TRUE,
  legData = FALSE, bmar, lmar, tmar, rmar, cexref = 0.9, cexind = 0.8)
}
\arguments{
\item{AMids}{Dataframe of genetic distances calculated by calculateAMids or calculateAMidsArith.}

\item{phenoFile}{Optional file with phenotype, color and order information for individuals and populations. An example file, called CorPheno, is contained in the 'extdata' folder with the package.}

\item{columnPlot}{Takes values 'I' or 'C'. 'I' is the default option. 'I' plots the normalised euclidean distances whereas 'C' plots the crude distances.}

\item{quantilePlot}{Logical. Takes values TRUE or FALSE. TRUE is the default option. If columnPlot is 'C', TRUE will plot the quantiles, FALSE will plot the raw values.}

\item{colorPlot}{Colors for the AMids. Possible choices are 'RedBl', 'RedBlGr' and 'BLBrewer'. The user can also provide a vector of colors.}

\item{sepLinesPop}{Logical. Takes values TRUE or FALSE. The default is TRUE.
If TRUE, a line demarcating populations is plotted.}

\item{plotIndNames}{Logical. Takes values TRUE or FALSE. The default is FALSE. 
If TRUE, the individual ids are plotted on the left axis.}

\item{legColor}{Logical. Takes values TRUE or FALSE. The default is TRUE. 
If TRUE, the legend for the colour gradient will be plotted in the top left.}

\item{legRef}{Logical. Takes values TRUE or FALSE. The default is TRUE. If TRUE, text giving names of references will be plotted along the x axis.}

\item{legPheno}{Logical. Takes values TRUE or 'no. The default is TRUE. If TRUE, will plot colour blocks relating to the population, dataset and regional origin of data if sample IDs have been given these in the Corpheno file, if not present, will plot them under 'Unspecified'.}

\item{legAxisPop}{Logical. Takes values TRUE or FALSE. The default is TRUE. 
If TRUE text will be plotted giving name and number of populations for samples used on the right y axis of the plot.}

\item{legData}{Logical. Takes values TRUE or FALSE. The default is FALSE.
If TRUE, the reference to the dataset used to create the reference is appended to the reference population name on the bottom x axis.}

\item{bmar}{Takes numeric value. Changes the size of the bottom outer margin of the plot. The default is empty. 
For more see ?par()}

\item{lmar}{Takes numeric value. Changes the size of the left outer margin of the plot. The default is empty.
For more see ?par()}

\item{tmar}{Takes numeric value. Changes the size of the top outer margin of the plot. The default is empty.
For more see ?par()}

\item{rmar}{Takes numeric value. Changes the size of the right outer margin of the plot. The default is empty. 
For more see ?par()}

\item{cexref}{Takes numeric value. Controls text size of reference names on y axis. Default is 0.9.}

\item{cexind}{Takes numeric value. Controls text size of sample names on y axis. Default is 0.8.
Individual sample IDs need plotIndNames = "yes" to display, this is set to FALSE by default.}
}
\description{
plotAMids is used to visualise the relationship amongst individuals and references.
}
\examples{
\dontrun{
Refs <- system.file('data', package = 'AncestryMapper')
tpeds <- system.file('extdata', package = 'AncestryMapper')
Corpheno <- system.file('extdata', 'CorPheno', package = 'AncestryMapper')
All00Frq <- system.file ('data', 'MinMaxFreq.rda', package = 'AncestryMapper')

genetic.distance <- calculateAMidsArith(pathTotpeds = tpeds,
                                   NameOut = 'Example',
                                   pathToAriMedoids = Refs,
                                   pathAll00 = All00Frq)

plotAMids(AMids = genetic.distance, phenoFile = Corpheno, columnPlot = "I")
}
}

