% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor_stability.R
\name{anchor_stability}
\alias{anchor_stability}
\title{anchor_stability}
\usage{
anchor_stability(
  x,
  anchor,
  target_variable,
  lambda = 0,
  alpha = 0.05,
  p_procedure = "naive"
)
}
\arguments{
\item{x}{is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{is a dataframe containing the matrix anchor containing the anchor variable}

\item{target_variable}{is the target variable name contained in the x dataframe}

\item{lambda}{indicates the lambda that is used in the Anchor Regression. 'CV' is used if it should be estimated by cross validation on the full subset.}

\item{alpha}{significance level for test decision on coefficient significance}

\item{p_procedure}{procedure to estimate stability. Option 1: naive - stable if effect is non-zero in all cases; Option 2: post-lasso - post selection inference using SelectiveInference package}
}
\value{
A dataframe containing the stability values for each coefficient
}
\description{
Perform an Anchor Stability Analysis as described in Rothenhäusler et al.2020
}
\examples{
x <- as.data.frame(matrix(data = rnorm(1000),nrow = 100,ncol = 10))
anchor <- as.data.frame(matrix(data = rnorm(200),nrow = 100,ncol = 2))
colnames(anchor) <- c('X1','X2')
gamma <- 2
target_variable <- 'V2'
anchor_stability(x, anchor, target_variable, lambda, alpha=0.05, p_procedure = "naive")
}
