% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_GBLD.R
\name{calculate_GBLD}
\alias{calculate_GBLD}
\title{Calculate the GBLD distance between trees in an AntibodyForests object. Code is derived from https://github.com/tahiri-lab/ClonalTreeClustering/blob/main/src/Python/GBLD_Metric_Final.ipynb
Farnia, M., Tahiri, N. New generalized metric based on branch length distance to compare B cell lineage trees. Algorithms Mol Biol 19, 22 (2024). https://doi.org/10.1186/s13015-024-00267-1}
\usage{
calculate_GBLD(AntibodyForests_object, min.nodes)
}
\arguments{
\item{AntibodyForests_object}{AntibodyForests-object, output from AntibodyForests()}

\item{min.nodes}{\itemize{
\item integer - The minimum number of nodes (including the germline) in a tree to include in the analysis. Default is 3.
}}
}
\value{
A matrix with the GBLD distances between trees in the AntibodyForests object.
}
\description{
Calculate the GBLD distance between trees in an AntibodyForests object. Code is derived from https://github.com/tahiri-lab/ClonalTreeClustering/blob/main/src/Python/GBLD_Metric_Final.ipynb
}
\examples{
GBLD_matrix <- calculate_GBLD(AntibodyForests_object = AntibodyForests::small_af)
GBLD_matrix[1:5, 1:5]
}
