% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{clear.urls}
\alias{clear.urls}
\title{Clear a list of URLs according parameters.}
\usage{
clear.urls(urls, remove_http_method = TRUE, remove_http_version = TRUE,
  remove_params_inside_url = TRUE, remove_query_string = TRUE)
}
\arguments{
\item{urls}{list of URLs}

\item{remove_http_method}{boolean. If the http method will be removed from the urls.}

\item{remove_http_version}{booelan. If the http version will be removed from the urls.}

\item{remove_params_inside_url}{boolean. If the parameters inside the URL, commonly used in REST web services, will be removed from the urls.}

\item{remove_query_string}{boolean. If the query string will be removed from the urls.}
}
\value{
a vector with the urls cleaned
}
\description{
Clear a list of URLs according parameters.
}
\examples{

#Load the path to the log file
path_combined = system.file("examples", "access_log_combined.txt", package = "ApacheLogProcessor")

#Read a log file with combined format and return it in a data frame
df1 = read.apache.access.log(path_combined)

#Clear the urls
urls <- clear.urls(df1$url)

#Clear the urls but do not remove query strings
urlsWithQS <- clear.urls(df1$url, remove_query_string = FALSE)

#Load a log which the urls have parameters inside
path2 = system.file("examples", 
"access_log_with_params_inside_url.txt", package = "ApacheLogProcessor")

#Read a log file with combined format and return it in a data frame
df2 = read.apache.access.log(path2, format = "common")

#Clear the urls with parameters inside
urls2 <- clear.urls(df2$url)

}
\author{
Diogo Silveira Mendonca
}
