% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{param}
\alias{param}
\title{Set or get Ar-Ar_Redux parameters}
\usage{
param(X, ...)
}
\arguments{
\item{X}{an object of class \code{\link{redux}}}

\item{...}{any combination of the parameters given below}
}
\value{
returns the modified \code{\link{redux}} object OR the
    current parameter values if no optional arguments are supplied.
}
\description{
This function is used to query and modify the half lives, standard
ages etc. associated with an object of class \code{\link{redux}}
}
\details{
\code{\link{param}} grants access to the following parameters:
 
\code{l0}: 40K decay constant (default value = 5.5492e-4 Ma-1,
Renne et al. [2010])\cr
\code{sl0}: standard error of the 40K decay constant (default value
= 0.0047e-4 Ma-1)\cr
\code{l7}: 37Ar decay constant (default value = 7.2438 yr-1, Renne
and Norman [2001])\cr
\code{sl7}: standard error of the 37Ar decay constant (default
value = 0.0083 yr-1)\cr
\code{l9}: 39Ar decay constant (0.002577 yr-1 Stoenner et
al. [1965])\cr
\code{sl9}: standard error of the 39Ar decay constant (0.000014
yr-1)\cr
\code{l6}: 36Cl decay constant (default value = 2301.3e-9 yr-1)\cr
\code{sl6}: standard error of the 36Cl decay constant (default
value = 7.6e-9 yr-1\cr
\code{pcl}: (36Cl/38Cl)-production rate (default value = 252.7 for
OSTR reactor, Renne et al. [2008])\cr
\code{spcl}: standard error of the (36Cl/38Cl)-production rate
(default value = 1.8)\cr
\code{ts}: age of the fluence monitor (default = 28.201 Myr for the
Fish Canyon Tuff, Kuiper et al. [2008])\cr
\code{sts}: standard error of the fluence monitor age (default
value = 0.023 Myr)\cr
\code{air}: atmospheric 40Ar/36Ar ratio (default value = 298.56,
Lee et al. [2006])\cr
\code{sair}: standard error of the atmospheric 40Ar/36Ar ratio
(default value = 0.155)
}
\examples{
data(Melbourne)
param(Melbourne$X)$air
Y <- param(Melbourne$X,air=295.5)
param(Y)$air
}
