% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADSIHT.R
\name{ADSIHT}
\alias{ADSIHT}
\title{Adaptive Double Sparse Iterative Hard Thresholding Algorithm (ADSIHT)}
\usage{
ADSIHT(
  x,
  y,
  group,
  s0,
  kappa = 0.9,
  ic.type = c("dsic", "loss"),
  ic.scale = 3,
  ic.coef = 3,
  L = 5,
  weight = rep(1, nrow(x)),
  coef1 = 1,
  coef2 = 1,
  eta = 0.8,
  max_iter = 20,
  method = "ols"
)
}
\arguments{
\item{x}{Input matrix, of dimension \eqn{n \times p}; each row is an observation
vector and each column is a predictor.}

\item{y}{The response variable of \code{n} observations.}

\item{group}{A vector indicating which group each variable belongs to
For variables in the same group, they should be located in adjacent columns of \code{x}
and their corresponding index in \code{group} should be the same.
Denote the first group as \code{1}, the second \code{2}, etc.}

\item{s0}{A vector that controls the degrees with group.
Default is \eqn{d^((l-1)/(L-1))} : \eqn{1 \leq l \leq L}, where d is the maximum group size.}

\item{kappa}{A parameter that controls the rapid of the decrease of threshold. Default is 0.9.}

\item{ic.type}{The type of criterion for choosing the support size.
Available options are \code{"dsic"}, \code{"loss"}.
Default is \code{"dsic"}.}

\item{ic.scale}{A non-negative value used for multiplying the penalty term
in information criterion. Default: \code{ic.scale = 3}.}

\item{ic.coef}{A non-negative value used for multiplying the penalty term
for choosing the optimal stopping time. Default: \code{ic.coef = 3}.}

\item{L}{The length of the sequence of s0. Default: \code{L = 5}.}

\item{weight}{The weight of the samples, with the default value set to 1 for each sample.}

\item{coef1}{A positive value to control the sub-optimal stopping time.}

\item{coef2}{A positive value to control the overall stopping time. A small value leads to larger search range.}

\item{eta}{A parameter controls the step size in the gradient descent step.
Default: \code{eta = 0.8}.}

\item{max_iter}{A parameter that controls the maximum number of line search, ignored if \code{OLS} is employed.}

\item{method}{Whether \code{ols} (default) or \code{linesearch} method should be employed.}
}
\value{
A \code{list} object comprising:
\item{beta}{A \eqn{p}-by-\code{length(s0)} matrix of coefficients, stored in column format.}
\item{intercept}{A \code{length(s0)} vector of intercepts}.
\item{lambda}{A \code{length(s0)} vector of threshold values}
\item{A_out}{The selected variables given threshold value in \code{lambda}.}
\item{ic}{The values of the specified criterion for each fitted model given threshold \code{lamdba}.}
}
\description{
An implementation of the sparse group selection in linear regression model via ADSIHT.
}
\examples{

n <- 200
m <- 100
d <- 10
s <- 5
s0 <- 5
data <- gen.data(n, m, d, s, s0)
fit <- ADSIHT(data$x, data$y, data$group)
fit$A_out[which.min(fit$ic)]
}
\author{
Yanhang Zhang, Zhifan Li, Shixiang Liu, Jianxin Yin.
}
