% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImage.R
\name{getHolesStatistics}
\alias{getHolesStatistics}
\title{calculate statistics about holes in a binary image}
\usage{
getHolesStatistics(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
an \code{\link{AFMImage}}
}
\description{
\code{getHolesStatistics} returns a binary AFMImage
}
\examples{
\dontrun{
library(AFM)

data(AFMImageOfAluminiumInterface)
newAFMImage<-copy(AFMImageOfAluminiumInterface)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-multiplyHeightsAFMImage(newAFMImage, multiplier=2)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-filterAFMImage(newAFMImage,  Min=140, Max=300)
displayIn3D(newAFMImage,noLight=TRUE)
newAFMImage<-makeBinaryAFMImage(newAFMImage)
displayIn3D(newAFMImage,noLight=TRUE)

holesStats<-getHolesStatistics(newAFMImage)
print(holesStats)
}
}
\author{
M.Beauvais
}
