% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMImageAnalyser.R
\name{checkNormality}
\alias{checkNormality}
\title{Check visualy of the normality of the sample}
\usage{
checkNormality(..., AFMImage)
}
\arguments{
\item{...}{pngfullfilename (optional): directory and filename to save the visual check to png or pdffullfilename(optional): directory and filename to save the visual check to pdf}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\description{
\code{checkNormality} performs a visual check to know if the distribution of heights of an \code{\link{AFMImage}} follows a normal distribution. The function displays Quantile/Quantile and distribution plots.
}
\examples{
\dontrun{
library(AFM)

# display Quantile/Quantile and distribution plots.
  data(AFMImageOfNormallyDistributedHeights)
  checkNormality(AFMImage= AFMImageOfNormallyDistributedHeights)

# display and save on disk Quantile/Quantile and distribution plots.
  data(AFMImageOfNormallyDistributedHeights)
  checkNormality(AFMImage= AFMImageOfNormallyDistributedHeights, 
                 pngfullfilename=paste(tempdir(), "checkNormality.png", sep="/"))
}
}
\references{
Olea2006, Ricardo A. Olea "A six-step practical approach to semivariogram modeling", 2006, "Stochastic Environmental Research and Risk Assessment, Volume 20, Issue 5 , pp 307-318"
}
\author{
M.Beauvais
}
