% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMGaussianMixAnalyser.R
\name{performGaussianMixCalculation}
\alias{performGaussianMixCalculation}
\title{Perform  the calculation for the Gaussian mixes}
\usage{
performGaussianMixCalculation(AFMImageGaussianMixAnalysis, AFMImage)
}
\arguments{
\item{AFMImageGaussianMixAnalysis}{an \code{\link{AFMImageGaussianMixAnalysis}} to manage and store the results of PSD analysis}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\description{
\code{\link{performGaussianMixCalculation}} perform all the calculation for PSD exploitation
}
\examples{
\dontrun{
library(AFM)

data(AFMImageCollagenNetwork)

AFMImage<-AFMImageCollagenNetwork
AFMImage@fullfilename<-"/Users/one/AFMImageCollagenNetwork.txt"
gMixAnalysis<-AFMImageGaussianMixAnalysis()
# from two components
gMixAnalysis@minGaussianMix<-2
# to four components
gMixAnalysis@maxGaussianMix<-4
# convergence criteria
gMixAnalysis@epsilonGaussianMix<-1e-4
# Create a closure to update progress
gMixAnalysis@updateProgress<- function(value = NULL, detail = NULL, message = NULL) {
  if (exists("progressGaussianMix")){
    if (!is.null(message)) {
      progressGaussianMix$set(message = message, value = 0)
    }else{
      progressGaussianMix$set(value = value, detail = detail)
    }
  }
}
gMixAnalysis<-performGaussianMixCalculation(AFMImageGaussianMixAnalysis= gMixAnalysis, AFMImage)
print("done performGaussianMixCalculation")
}
}
\author{
M.Beauvais
}
