% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{anisotropic_numerical_msd}
\alias{anisotropic_numerical_msd}
\title{Compute anisotropic numerical MSD}
\usage{
anisotropic_numerical_msd(pos, M, len_t)
}
\arguments{
\item{pos}{position matrix for particle trajectory. See 'Details'.}

\item{M}{number of particles}

\item{len_t}{number of time steps}
}
\value{
A matrix of numerical MSD for given lag times in x,y-directions,
dimension 2 by \code{len_t}.
}
\description{
Compute numerical mean squared displacement(MSD) based on particle trajectory
for anisotropic processes in x,y-directions separately.
}
\details{
Input \code{pos} should be the position matrix with dimension
\code{M}\eqn{\times}{\%\times}\code{len_t}. See \code{\link{bm_particle_intensity}},
\code{\link{ou_particle_intensity}}, \code{\link{fbm_particle_intensity}},
\code{\link{fbm_ou_particle_intensity}}.
}
\examples{
library(AIUQ)
# Simulate particle trajectory for BM
M = 10
len_t = 50
sigma = c(0.5,0.1)
pos0 = matrix(100/8+0.75*100*runif(M*2),nrow=M,ncol=2)
pos = anisotropic_bm_particle_intensity(pos0=pos0,M=M,len_t=len_t,sigma=sigma)

# Compute numerical MSD
(num_msd = anisotropic_numerical_msd(pos=pos, M=M, len_t=len_t))
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
