% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{show.aniso_sam}
\alias{show.aniso_sam}
\title{Show scattering analysis of microscopy for anisotropic processes (aniso_SAM) object}
\usage{
show.aniso_sam(object)
}
\arguments{
\item{object}{an S4 object of class \code{aniso_SAM}}
}
\value{
Show a list of important parameters in class \code{aniso_SAM}.
}
\description{
Function to print the \code{aniso_SAM} class object after the
\code{aniso_SAM} model has been constructed.
}
\examples{
library(AIUQ)

## Simulate BM and get estimated parameters using BM model
# Simulation
aniso_sim_bm = aniso_simulation(sz=100,len_t=100,sigma_bm=c(0.5,0.3))
show(aniso_sim_bm)

# AIUQ method: fitting using BM model
aniso_sam = aniso_SAM(sim_object=aniso_sim_bm, AIUQ_thr=c(0.99,0))
show(aniso_sam)

}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.
}
\author{
\packageAuthor{AIUQ}
}
