% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sites_by_species.R
\name{sites_by_species}
\alias{sites_by_species}
\title{Sites by species}
\usage{
sites_by_species(
  taxon,
  wkt,
  gridsize = 0.1,
  SPdata.frame = FALSE,
  verbose = ala_config()$verbose
)
}
\arguments{
\item{taxon}{string: the identifier to get the species data from the ala biocache. E.g. "genus:Heleioporus". See \code{ala_fields("occurrence_stored")} for valid field names}

\item{wkt}{string: Bounding area in Well Known Text (WKT) format. E.g. "POLYGON((118 -30,146 -30,146 -11,118 -11,118 -30))".}

\item{gridsize}{numeric: size of output grid cells in decimal degrees. E.g. 0.1 (=~10km)}

\item{SPdata.frame}{logical: should the output be returned as a SpatialPointsDataFrame of the sp package?}

\item{verbose}{logical: show additional progress information? [default is set by ala_config()]}
}
\value{
A dataframe or a SpatialPointsDataFrame containing the species by sites data. Columns will include longitude, latitude, and each species present. Values for species are record counts (i.e. number of recorded occurrences of that taxon in each grid cell). The \code{guid} attribute of the data frame gives the guids of the species (columns) as a named character vector
}
\description{
A data.frame is returned as grid cells by species with values in each cell being the number of occurrences of each species. No null (all zero) species should be returned. The coordinates returned are the TOP-LEFT corner of the grid cell.
}
\examples{
\dontrun{
# Eucalyptus in Tasmania based on a 0.1 degree grid
ss <- sites_by_species(taxon="genus:Eucalyptus", wkt="POLYGON((144 -43,148 -43,148 -40,
  144 -40,144 -43))", gridsize=0.1, verbose=TRUE)
head(ss[, 1:6])

## get the guid of the first species
attr(ss,"guid")[1]
#' # Steps: 1. POST webservice creates a task (use single quotes around data-binary argument)
#curl 'https://spatial.ala.org.au/ws/tasks/create?userId=0' --data-binary name=PointsToGrid
#&input={"area":[{"name":"Current extent"
#,"wkt":"POLYGON((144 -43,148 -43,148 -40,144 -40,144 -43))"}]
#,"occurrenceDensity":false,"sitesBySpecies":true,"speciesRichness":false
#,"species":{"q":["genus:Eucalyptus"]
#,"bs":"https://biocache-ws.ala.org.au/ws/","name":"genus:Eucalyptus"}
#,"gridCellSize":0.1,"resolution":0.01,"movingAverage":"1x1 (no moving average)"}'
#resp eg '{"name":"PointsToGrid","created":1552881125953,"email":"null","history":{}
#,"tag":"null","userId":"0","sessionId":"null","status":0,"id":<id>}
# 2. check status values: 0 = in_queue, 1 = running, 2 = cancelled, 3 = error, 4 = finished 
#curl 'https://spatial.ala.org.au/ws/tasks/status/<id>'
#waiting: {"status":1,"message":"getting species data","id":<id>,"name":"PointsToGrid"}
#complete:{"status":4,"message":"finished","id":<id>,"name":"PointsToGrid"
#,"history":{"1552879452131":"finished","1552879452155":"finished (id:<id>)"}
#,"output":[{"name":"files","file":"SitesBySpecies.csv","taskId":<id>,"id":33111}
#,{"name":"sxs_metadata.html","taskId":<id>,"file":"sxs_metadata.html","id":33109}
#,{"file":"download.zip","taskId":<id>,"name":"download.zip","id":33110}]}
#failed:  {"status":4,"message":"finished","id":<id>,"name":"PointsToGrid"
#,"history":{"1552881921817":"failed (id:<id>)"}}
# 3. download the zip and extract the file
# https://spatial.ala.org.au/ws/tasks/output/<id>/download.zip
# https://spatial.ala.org.au/ws/tasks/output/<id>/SitesBySpecies.csv
}

}
\references{
Associated web services: \url{https://spatial.ala.org.au/ws/capabilities} see PointsToGrid/sitesBySpecies

\url{http://www.geoapi.org/3.0/javadoc/org/opengis/referencing/doc-files/WKT.html}
}
