% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occurrence_details.R
\name{occurrence_details}
\alias{occurrence_details}
\title{Retrieve the full details of occurrence records}
\usage{
occurrence_details(uuid, verbose = ala_config()$verbose)
}
\arguments{
\item{uuid}{string: one or more record ids, as returned by
\code{\link{occurrences}} (in the \code{data$id} column)}

\item{verbose}{logical: show additional progress information?
[default is set by ala_config()]}
}
\value{
A named list (named by uuid), each element of which is a list
containing the details for that uuid. This inner list will be empty if no
match is found for the supplied uuid
}
\description{
Note that this makes a separate web request for each occurrence uuid, and
so may not be wise to use on a large number of uuids.
}
\examples{
\dontrun{
s1 <- occurrence_details("f259c5ce-200c-41a2-b73a-e36a91f748f7")
str(s1, max.level = 3)
}
}
\references{
Associated ALA web service: \url{https://api.ala.org.au/#ws102}
}
\seealso{
\code{\link{occurrences}} \code{\link{ala_config}}
}
