% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_1_table_1}
\alias{chapter_1_table_1}
\alias{C1T1}
\alias{Chapter_1_Table_1}
\alias{c1t1}
\title{The data used in Chapter 1, Table 1}
\format{An object of class \code{data.frame} with 10 rows and 3 columns.}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and 
analyzing data: {A} model comparison perspective}. (3rd ed.). Routledge.
}
\usage{
data(chapter_1_table_1)
}
\description{
Assume that a developmental psychologist is interested in whether brief training can improve performance of 2-year-old children on a test of mental abilities. The test selected is the Mental Scale of the Bayley Scales of Infant Development, which yields a mental age in months. To increase the sensitivity of the experiment, the psychologist decides to rectruit sets of twins and randomly assigns one member of each pair to the treatment condition. The treatment consists of simply watching a videotape of another child attempting to perform tasks similar to those making up the Bayley Mental Scale. The other member of each pair plays in a waiting area as a time-filling activity while the first is viewing the videotape. Then both children are individually given the Bayley by a tester who is blind to their assigned conditions. A different set of twins takes part in the experiment each day, Monday through Friday, and the experiment extends over a 2-week period. Table 1.1 shows the data for the study in the middle columns.
}
\section{Variables}{

\describe{
 \item{treat}{scores for the treatment group}
 \item{control}{scores for the control group}
 \item{week}{identifies the week}}
}

\section{Synonym}{

C1T1
}

\examples{
# Load the data
data(chapter_1_table_1)

# Or, alternatively load the data as
data(C1T1)

# View the structure
str(chapter_1_table_1)

chapter_1_table_1$Difference <- chapter_1_table_1$treat - chapter_1_table_1$control

# Summaries by week. 
summary(chapter_1_table_1[chapter_1_table_1$week==1,])
summary(chapter_1_table_1[chapter_1_table_1$week==2,])
}
\references{
Maxwell, S. E., Delaney, H. D., \& Kelley, K. (forthcoming). \emph{Designing experiments and analyzing data: 
{A} model comparison perspective} (3rd ed.). Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
