% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_isolates.R
\name{key_antibiotics}
\alias{key_antibiotics}
\title{Key antibiotics based on bacteria ID}
\usage{
key_antibiotics(tbl, col_bactcode = "bactid", info = TRUE, amcl = "amcl",
  amox = "amox", cfot = "cfot", cfta = "cfta", cftr = "cftr",
  cfur = "cfur", cipr = "cipr", clar = "clar", clin = "clin",
  clox = "clox", doxy = "doxy", gent = "gent", line = "line",
  mero = "mero", peni = "peni", pita = "pita", rifa = "rifa",
  teic = "teic", trsu = "trsu", vanc = "vanc")
}
\arguments{
\item{tbl}{table with antibiotics coloms, like \code{amox} and \code{amcl}.}

\item{col_bactcode}{column of bacteria IDs in \code{tbl}; these should occur in \code{bactlist$bactid}, see \code{\link{bactlist}}}

\item{info}{print warnings}

\item{amcl, amox, cfot, cfta, cftr, cfur, cipr, clar, clin, clox, doxy, gent, line, mero, peni, pita, rifa, teic, trsu, vanc}{column names of antibiotics.}
}
\value{
Character of length 1.
}
\description{
Key antibiotics based on bacteria ID
}
\examples{
\donttest{
#' # set key antibiotics to a new variable
tbl$keyab <- key_antibiotics(tbl)
}
}
\seealso{
\code{\link{mo_property}} \code{\link{ablist}}
}
