% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms}
\alias{microorganisms}
\title{Data set with taxonomic data from ITIS}
\format{A \code{\link{data.frame}} with 18,833 observations and 15 variables:
\describe{
  \item{\code{mo}}{ID of microorganism}
  \item{\code{tsn}}{Taxonomic Serial Number (TSN), as defined by ITIS}
  \item{\code{genus}}{Taxonomic genus of the microorganism as found in ITIS, see Source}
  \item{\code{species}}{Taxonomic species of the microorganism as found in ITIS, see Source}
  \item{\code{subspecies}}{Taxonomic subspecies of the microorganism as found in ITIS, see Source}
  \item{\code{fullname}}{Full name, like \code{"Echerichia coli"}}
  \item{\code{family}}{Taxonomic family of the microorganism as found in ITIS, see Source}
  \item{\code{order}}{Taxonomic order of the microorganism as found in ITIS, see Source}
  \item{\code{class}}{Taxonomic class of the microorganism as found in ITIS, see Source}
  \item{\code{phylum}}{Taxonomic phylum of the microorganism as found in ITIS, see Source}
  \item{\code{subkingdom}}{Taxonomic subkingdom of the microorganism as found in ITIS, see Source}
  \item{\code{gramstain}}{Gram of microorganism, like \code{"Gram negative"}}
  \item{\code{type}}{Type of microorganism, like \code{"Bacteria"} and \code{"Fungi"}}
  \item{\code{prevalence}}{A rounded integer based on prevalence of the microorganism. Used internally by \code{\link{as.mo}}, otherwise quite meaningless.}
  \item{\code{ref}}{Author(s) and year of concerning publication as found in ITIS, see Source}
}}
\source{
[3] Integrated Taxonomic Information System (ITIS) on-line database, \url{https://www.itis.gov}.
}
\usage{
microorganisms
}
\description{
A data set containing the complete microbial taxonomy of the kingdoms Bacteria, Fungi and Protozoa. MO codes can be looked up using \code{\link{as.mo}}.
}
\section{ITIS}{

\if{html}{\figure{itis_logo.jpg}{options: height=60px style=margin-bottom:5px} \cr}
This package contains the \strong{complete microbial taxonomic data} (with all  seven taxonomic ranks - from subkingdom to subspecies) from the publicly available Integrated Taxonomic Information System (ITIS, \url{https://www.itis.gov}).

The complete taxonomic kingdoms Bacteria, Fungi and Protozoa are included in this package, as well as all previously accepted names known to ITIS. Furthermore, the responsible authors and year of publication are available too. This allows users to use authoritative taxonomic information for their data analyses on any microorganisms, not only human pathogens.

ITIS is a partnership of U.S., Canadian, and Mexican agencies and taxonomic specialists [3].
}

\seealso{
\code{\link{as.mo}} \code{\link{mo_property}} \code{\link{microorganisms.umcg}}
}
\keyword{datasets}
