% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{count}
\alias{count}
\alias{count_R}
\alias{count_IR}
\alias{count_I}
\alias{count_SI}
\alias{count_S}
\alias{count_all}
\alias{n_rsi}
\alias{count_df}
\title{Count isolates}
\source{
Wickham H. \strong{Tidy Data.} The Journal of Statistical Software, vol. 59, 2014. \url{http://vita.had.co.nz/papers/tidy-data.html}
}
\usage{
count_R(..., also_single_tested = FALSE)

count_IR(..., also_single_tested = FALSE)

count_I(..., also_single_tested = FALSE)

count_SI(..., also_single_tested = FALSE)

count_S(..., also_single_tested = FALSE)

count_all(...)

n_rsi(...)

count_df(data, translate_ab = getOption("get_antibiotic_names",
  "official"), combine_IR = FALSE)
}
\arguments{
\item{...}{one or more vectors (or columns) with antibiotic interpretations. They will be transformed internally with \code{\link{as.rsi}} if needed.}

\item{also_single_tested}{a logical to indicate whether (in combination therapies) also observations should be included where not all antibiotics were tested, but at least one of the tested antibiotics contains a target interpretation (e.g. S in case of \code{portion_S} and R in case of \code{portion_R}). \strong{This would lead to selection bias in almost all cases.}}

\item{data}{a \code{data.frame} containing columns with class \code{rsi} (see \code{\link{as.rsi}})}

\item{translate_ab}{a column name of the \code{\link{antibiotics}} data set to translate the antibiotic abbreviations to, using \code{\link{abname}}. This can be set with \code{\link{getOption}("get_antibiotic_names")}.}

\item{combine_IR}{a logical to indicate whether all values of I and R must be merged into one, so the output only consists of S vs. IR (susceptible vs. non-susceptible)}
}
\value{
Integer
}
\description{
These functions can be used to count resistant/susceptible microbial isolates. All functions support quasiquotation with pipes, can be used in \code{dplyr}s \code{\link[dplyr]{summarise}} and support grouped variables, see \emph{Examples}.

\code{count_R} and \code{count_IR} can be used to count resistant isolates, \code{count_S} and \code{count_SI} can be used to count susceptible isolates.\cr
}
\details{
These functions are meant to count isolates. Use the \code{\link{portion}_*} functions to calculate microbial resistance.

\code{n_rsi} is an alias of \code{count_all}. They can be used to count all available isolates, i.e. where all input antibiotics have an available result (S, I or R). Their use is equal to \code{\link{n_distinct}}. Their function is equal to \code{count_S(...) + count_IR(...)}.

\code{count_df} takes any variable from \code{data} that has an \code{"rsi"} class (created with \code{\link{as.rsi}}) and counts the amounts of R, I and S. The resulting \emph{tidy data} (see Source) \code{data.frame} will have three rows (S/I/R) and a column for each variable with class \code{"rsi"}.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# septic_patients is a data set available in the AMR package. It is true, genuine data.
?septic_patients

# Count resistant isolates
count_R(septic_patients$amox)
count_IR(septic_patients$amox)

# Or susceptible isolates
count_S(septic_patients$amox)
count_SI(septic_patients$amox)

# Count all available isolates
count_all(septic_patients$amox)
n_rsi(septic_patients$amox)

# Since n_rsi counts available isolates, you can
# calculate back to count e.g. non-susceptible isolates.
# This results in the same:
count_IR(septic_patients$amox)
portion_IR(septic_patients$amox) * n_rsi(septic_patients$amox)

library(dplyr)
septic_patients \%>\%
  group_by(hospital_id) \%>\%
  summarise(R  = count_R(cipr),
            I  = count_I(cipr),
            S  = count_S(cipr),
            n1 = count_all(cipr), # the actual total; sum of all three
            n2 = n_rsi(cipr),     # same - analogous to n_distinct
            total = n())          # NOT the number of tested isolates!

# Count co-resistance between amoxicillin/clav acid and gentamicin,
# so we can see that combination therapy does a lot more than mono therapy.
# Please mind that `portion_S` calculates percentages right away instead.
count_S(septic_patients$amcl)   # S = 1057 (67.1\%)
count_all(septic_patients$amcl) # n = 1576

count_S(septic_patients$gent)   # S = 1372 (74.0\%)
count_all(septic_patients$gent) # n = 1855

with(septic_patients,
     count_S(amcl, gent))       # S = 1396 (92.0\%)
with(septic_patients,           # n = 1517
     n_rsi(amcl, gent))

# Get portions S/I/R immediately of all rsi columns
septic_patients \%>\%
  select(amox, cipr) \%>\%
  count_df(translate = FALSE)

# It also supports grouping variables
septic_patients \%>\%
  select(hospital_id, amox, cipr) \%>\%
  group_by(hospital_id) \%>\%
  count_df(translate = FALSE)

}
\seealso{
\code{\link{portion}_*} to calculate microbial resistance and susceptibility.
}
\keyword{antibiotics}
\keyword{isolate}
\keyword{isolates}
\keyword{resistance}
\keyword{rsi}
\keyword{susceptibility}
