% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like.R
\name{like}
\alias{like}
\alias{\%like\%}
\title{Pattern Matching}
\source{
Idea from the \href{https://github.com/Rdatatable/data.table/blob/master/R/like.R}{\code{like} function from the \code{data.table} package}, but made it case insensitive at default and let it support multiple patterns.
}
\usage{
like(x, pattern)

x \%like\% pattern
}
\arguments{
\item{x}{a character vector where matches are sought, or an
    object which can be coerced by \code{as.character} to a character
    vector.  \link{Long vectors} are supported.}

\item{pattern}{character string containing a \link{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr} and \code{gregexpr}.}
}
\value{
A \code{logical} vector
}
\description{
Convenient wrapper around \code{\link[base]{grep}} to match a pattern: \code{a \%like\% b}. It always returns a \code{logical} vector and is always case-insensitive. Also, \code{pattern} (\code{b}) can be as long as \code{x} (\code{a}) to compare items of each index in both vectors.
}
\details{
Using RStudio? This function can also be inserted from the Addins menu and can have its own Keyboard Shortcut like Ctrl+Shift+L or Cmd+Shift+L (see Tools > Modify Keyboard Shortcuts...).
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
# simple test
a <- "This is a test"
b <- "TEST"
a \%like\% b
#> TRUE
b \%like\% a
#> FALSE

# also supports multiple patterns, length must be equal to x
a <- c("Test case", "Something different", "Yet another thing")
b <- c("case", "diff", "yet")
a \%like\% b
#> TRUE TRUE TRUE

# get frequencies of bacteria whose name start with 'Ent' or 'ent'
library(dplyr)
septic_patients \%>\%
  left_join_microorganisms() \%>\%
  filter(genus \%like\% '^ent') \%>\%
  freq(genus, species)
}
\seealso{
\code{\link[base]{grep}}
}
