% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifecycle.R
\name{lifecycle}
\alias{lifecycle}
\title{Lifecycles of functions in the \code{AMR} package}
\description{
Our functions are categorised using \href{https://www.tidyverse.org/lifecycle}{the lifecycle circle of the \code{tidyverse} as found on www.tidyverse.org/lifecycle}.

\if{html}{\figure{lifecycle_tidyverse.svg}{options: height=200px style=margin-bottom:5px} \cr}
This page contains a section for every lifecycle (with text borrowed from the aforementioned \code{tidyverse} website), so they can be used in the manual pages of our functions.
}
\section{Experimental lifecycle}{

\if{html}{\figure{lifecycle_experimental.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{experimental}. An experimental function is in the very early stages of development. The unlying code might be changing frequently as we rapidly iterate and explore variations in search of the best fit. Experimental functions might be removed without deprecation, so you are generally best off waiting until a function is more mature before you use it in production code. Experimental functions will not be included in releases we submit to CRAN.
}

\section{Maturing lifecycle}{

\if{html}{\figure{lifecycle_maturing.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{maturing}. The unlying code of a maturing function has been roughed out, but finer details might still change. We will strive to maintain backward compatibility, but the function needs wider usage and more extensive testing in order to optimise the unlying code.
}

\section{Stable lifecycle}{

\if{html}{\figure{lifecycle_stable.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{stable}. In a stable function, we are largely happy with the unlying code, and major changes are unlikely. This means that the unlying code will generally evolve by adding new arguments; we will avoid removing arguments or changing the meaning of existing arguments.

If the unlying code needs breaking changes, they will occur gradually. To begin with, the function or argument will be deprecated; it will continue to work but will emit an message informing you of the change. Next, typically after at least one newly released version on CRAN, the message will be transformed to an error.
}

\section{Retired lifecycle}{

\if{html}{\figure{lifecycle_retired.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{retired}. A retired function is no longer under active development, and (if appropiate) a better alternative is available. We will only make the necessary changes to ensure that retired functions remain available. No new arguments will be added, and only the most critical bugs will be fixed.
}

\section{Archived lifecycle}{

\if{html}{\figure{lifecycle_archived.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{archived}. The development of an archived function has ended, and it is no longer available in future package versions.
}

\section{Dormant lifecycle}{

\if{html}{\figure{lifecycle_dormant.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{dormant}. A dormant function is currently not under active development and has not reached a stable phase. We might return to it in the future. As with experimental functions, you are best off waiting until a function is more mature before you use it in production code.
}

\section{Questioning lifecycle}{

\if{html}{\figure{lifecycle_questioning.svg}{options: style=margin-bottom:5px} \cr}
The \link[AMR:lifecycle]{lifecycle} of this function is \strong{questioning}. We are no longer convinced that this function is the optimal approach (but we do not know yet what a better approach would be), or whether this function should be in our \code{AMR} package at all.
}

