% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_antimicrobials.R
\name{add_custom_antimicrobials}
\alias{add_custom_antimicrobials}
\alias{clear_custom_antimicrobials}
\title{Add Custom Antimicrobials}
\usage{
add_custom_antimicrobials(x)

clear_custom_antimicrobials()
}
\arguments{
\item{x}{a \link{data.frame} resembling the \link{antibiotics} data set, at least containing columns "ab" and "name"}
}
\description{
With \code{\link[=add_custom_antimicrobials]{add_custom_antimicrobials()}} you can add your own custom antimicrobial drug names and codes.
}
\details{
\strong{Important:} Due to how \R works, the \code{\link[=add_custom_antimicrobials]{add_custom_antimicrobials()}} function has to be run in every \R session - added antimicrobials are not stored between sessions and are thus lost when \R is exited.

There are two ways to circumvent this and automate the process of adding antimicrobials:

\strong{Method 1:} Using the \link[=AMR-options]{package option} \code{\link[=AMR-options]{AMR_custom_ab}}, which is the preferred method. To use this method:
\enumerate{
\item Create a data set in the structure of the \link{antibiotics} data set (containing at the very least columns "ab" and "name") and save it with \code{\link[=saveRDS]{saveRDS()}} to a location of choice, e.g. \code{"~/my_custom_ab.rds"}, or any remote location.
\item Set the file location to the \link[=AMR-options]{package option} \code{\link[=AMR-options]{AMR_custom_ab}}: \code{options(AMR_custom_ab = "~/my_custom_ab.rds")}. This can even be a remote file location, such as an https URL. Since options are not saved between \R sessions, it is best to save this option to the \code{.Rprofile} file so that it will be loaded on start-up of \R. To do this, open the \code{.Rprofile} file using e.g. \code{utils::file.edit("~/.Rprofile")}, add this text and save the file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Add custom antimicrobial codes:
options(AMR_custom_ab = "~/my_custom_ab.rds")
}\if{html}{\out{</div>}}

Upon package load, this file will be loaded and run through the \code{\link[=add_custom_antimicrobials]{add_custom_antimicrobials()}} function.
}

\strong{Method 2:} Loading the antimicrobial additions directly from your \code{.Rprofile} file. Note that the definitions will be stored in a user-specific \R file, which is a suboptimal workflow. To use this method:
\enumerate{
\item Edit the \code{.Rprofile} file using e.g. \code{utils::file.edit("~/.Rprofile")}.
\item Add a text like below and save the file:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ # Add custom antibiotic drug codes:
 AMR::add_custom_antimicrobials(
   data.frame(ab = "TESTAB",
              name = "Test Antibiotic",
              group = "Test Group")
 )
}\if{html}{\out{</div>}}
}

Use \code{\link[=clear_custom_antimicrobials]{clear_custom_antimicrobials()}} to clear the previously added antimicrobials.
}
\examples{
\donttest{

# returns NA and throws a warning (which is suppressed here):
suppressWarnings(
  as.ab("testab")
)

# now add a custom entry - it will be considered by as.ab() and
# all ab_*() functions
add_custom_antimicrobials(
  data.frame(
    ab = "TESTAB",
    name = "Test Antibiotic",
    # you can add any property present in the
    # 'antibiotics' data set, such as 'group':
    group = "Test Group"
  )
)

# "testab" is now a new antibiotic:
as.ab("testab")
ab_name("testab")
ab_group("testab")

ab_info("testab")


# Add Co-fluampicil, which is one of the many J01CR50 codes, see
# https://www.whocc.no/ddd/list_of_ddds_combined_products/
add_custom_antimicrobials(
  data.frame(
    ab = "COFLU",
    name = "Co-fluampicil",
    atc = "J01CR50",
    group = "Beta-lactams/penicillins"
  )
)
ab_atc("Co-fluampicil")
ab_name("J01CR50")

# even antibiotic selectors work
x <- data.frame(
  random_column = "some value",
  coflu = as.sir("S"),
  ampicillin = as.sir("R")
)
x
x[, betalactams()]
}
}
\seealso{
\code{\link[=add_custom_microorganisms]{add_custom_microorganisms()}} to add custom microorganisms.
}
