% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_biosample.R
\name{export_ncbi_biosample}
\alias{export_ncbi_biosample}
\title{Export Data Set as NCBI BioSample Antibiogram}
\usage{
export_ncbi_biosample(x, filename = paste0("biosample_", format(Sys.time(),
  "\%Y-\%m-\%d-\%H\%M\%S"), ".xlsx"), type = "pathogen MIC",
  columns = where(is.mic), save_as_xlsx = TRUE)
}
\arguments{
\item{x}{A data set.}

\item{filename}{A character string specifying the file name.}

\item{type}{A character string specifying the type of data set, either "pathogen MIC" or "beta-lactamase MIC", see \url{https://www.ncbi.nlm.nih.gov/biosample/docs/}.}
}
\description{
Export Data Set as NCBI BioSample Antibiogram
}
\keyword{internal}
