% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOFA-contrastFrequencies.R
\name{contrastFrequencies}
\alias{contrastFrequencies}
\title{contrastFrequencies: contrasts analysis of frequency data.}
\usage{
contrastFrequencies(w = NULL, contrasts = NULL)
}
\arguments{
\item{w}{An ANOFA object obtained from \code{anofa()} or \code{emFrequencies()};}

\item{contrasts}{A list that gives the weights for the contrasts to analyze.
The contrasts within the list can be given names to distinguish them.
The contrast weights must sum to zero and their cross-products must equal 0
as well.}
}
\value{
a model fit of the constrasts.
}
\description{
The function \code{contrastFrequencies()} performs contrasts analyses
of frequencies after an omnibus analysis has been obtained with \code{anofa()}
according to the ANOFA framework. See \insertCite{lc23b}{ANOFA} for more.
}
\details{
contrastFrequencies computes the Gs for the contrasts,
testing the hypothesis that it equals zero.
The contrasts are each 1 degree of freedom, and the sum of the contrasts'
degrees of freedom totalize the effect being decomposed.
}
\examples{
# Basic example using a two-factors design with the data in compiled format. 
# Ficticious data present frequency of observation classified according
# to Intensity (three levels) and Pitch (two levels) for 6 possible cells.
minimalExample

# performs the omnibus analysis first (mandatory):
w <- anofa(Frequency ~ Intensity * Pitch, minimalExample) 
summary(w)

# execute the simple effect of Pitch for every levels of Intensity
e <- emFrequencies(w, ~ Intensity | Pitch)
summary(e)

# For each Pitch, contrast the three intensities, first
# by comparing the first two levels to the third, second
# by comparing the first to the second level:
w3 <- contrastFrequencies( e, list(
         contrast1 = c(1,  1, -2)/2,
         contrast2 = c(1, -1,  0) )
      )
summary(w3)

# Example using the Landis et al. (2013) data, a 3 x 5 design involving 
# program of care (3 levels) and provider of care (5 levels).
LandisBarrettGalvin2013

# performs the omnibus analysis first (mandatory):
w <- anofa(obsfreq ~ provider * program, LandisBarrettGalvin2013) 
summary(w)

# execute the simple effect of Pitch for every levels of Intensity
e <- emFrequencies(w, ~ program | provider)
summary(e)

# For each Pitch, contrast the three intensities, first
# by comparing the first two levels to the third, second
# by comparing the first to the second level:
w3 <- contrastFrequencies( e, list(
         contrast1 = c(1,  1, -2)/2,
         contrast2 = c(1, -1,  0) )
      )
summary(w3)



}
\references{
\insertAllCited{}
}
