% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gehan.wilcoxon.R
\name{gehan.wilcoxon}
\alias{gehan.wilcoxon}
\title{Perform Gehan-Wilcoxon test}
\usage{
gehan.wilcoxon(
  x,
  y,
  x.c,
  y.c,
  alternative = c("two.sided", "less", "greater"),
  max.exact.perms = 1e+05,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector of same length as y, x.c, y.c}

\item{y}{Numeric vector of same length as x, x.c, y.c}

\item{x.c}{Binary vector of same length as x, y, x.c}

\item{y.c}{Binary vector of same length as x, y, y.c}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{gehan.wilcoxon()} performs the Gehan-Wilcoxon test and is used in chapter 9 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 9.1 from "Applied Nonparametric Statistical Methods" (5th edition)
gehan.wilcoxon(ch9$symp.survtime, ch9$asymp.survtime,
  ch9$symp.censor, ch9$asymp.censor, alternative = "less",
  do.exact = FALSE, do.asymp = TRUE)

# Exercise 9.5 from "Applied Nonparametric Statistical Methods" (5th edition)
gehan.wilcoxon(ch9$regimeA.survtime, ch9$regimeB.survtime,
  ch9$regimeA.censor, ch9$regimeB.censor, do.exact = FALSE, do.asymp = TRUE)

}
