% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.ds.grp.R
\name{perm.ds.grp}
\alias{perm.ds.grp}
\title{Data stream permutation for association data}
\usage{
perm.ds.grp(df, scan, ctrlf = NULL, index = "sri", nperm, progress = TRUE)
}
\arguments{
\item{df}{A data frame.The data frame must have a column named 'ID'.}

\item{scan}{an integer indicating the column of scans of individual associations.}

\item{ctrlf}{A confounding factor by which to control group associations.}

\item{index}{Which type of index of associations to calculate:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x \div x+yAB+yA+yB}
\item 'hwi' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sqri' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}

\item{nperm}{number of permutations to perform.}

\item{progress}{a boolean indicating if the permutation process must be visible.}
}
\value{
list of square association index matrices. The first element of the list is the non-permuted association index matrix.
}
\description{
Pre-network permutation on association data for gambit of the group data collection protocol. The data frame must have a column named 'ID'.
}
\details{
Data stream permutation is a pre-network permutation approach. It is used on association data based on the gambit of the group.
}
\examples{
head(sim.grp)
t=perm.ds.grp(df = sim.grp, scan ='location', ctrlf ='time', nperm = 10, index = 'sri')
}
\references{
Whitehead, H. A. L. (1997). Analysing animal social structure. Animal behaviour, 53(5), 1053-1067.

Farine, D. R. (2017). A guide to null models for animal social network analysis. Methods in Ecology and Evolution.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
