% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_densityMatrix.R
\name{create_groupVariable}
\alias{create_groupVariable}
\title{Internal helper to create a group variable as base for a density matrix}
\usage{
create_groupVariable(dat, APC_var, groups_list)
}
\arguments{
\item{dat}{Dataset with a column \code{"age"}, \code{"period"} or
\code{"cohort"}, dependent on the specified \code{APC_var}.}

\item{APC_var}{One of \code{c("age","period","cohort")}.}

\item{groups_list}{A list with each element specifying the borders of one
row or column in the density matrix. E.g., if the period should be visualized
in decade columns from 1980 to 2009, specify
\code{groups_list = list(c(1980,1989), c(1990,1999), c(2000,2009))}.
The list can be named to specify labels for the categories.}
}
\value{
Vector for the grouping that can be added as additional column to
the data.
}
\description{
Internal helper function to create a group variable based on the
categorization of either age, period or cohort. To be called from within
\code{\link{plot_densityMatrix}}.
}
